<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartItemsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('cart_items', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->unsignedBigInteger('cart_id')->comment('id of cart tbl');
			$table->unsignedBigInteger('item_id')->comment('id of restaurant_menu tbl');
			$table->unsignedBigInteger('item_qty');
			$table->timestamps();

			$table->foreign('cart_id')->references('id')->on('carts');
			$table->foreign('item_id')->references('id')->on('restaurant_menus');


		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('cart_items');
	}

}
