<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderStatusTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_status', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name', 50);
            $table->integer('status')->default(1);
            $table->timestamps();
        });

        if (Schema::hasTable('order_status')) {
            DB::insert("INSERT INTO `order_status` (`id`, `name`, `status`, `created_at`) VALUES
            (1, 'Pending', 1, '2021-06-11 06:33:29'),
            (2, 'Accepted', 1, '2021-06-11 06:33:29'),
            (3, 'Rejected', 1, '2021-06-11 06:36:02'),
            (4, 'In Prep', 1, '2021-06-11 06:36:02'),
            (5, 'On the Way', 1, '2021-06-11 06:36:28'),
            (6, 'Completed', 1, '2021-06-11 06:36:28'),
            (7, 'Canceled', 1, '2021-06-11 06:36:47');");
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('order_status');
    }

}
