<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('orders', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->unsignedBigInteger('restaurant_id');
			$table->unsignedBigInteger('user_id');
			$table->double('delivery_charge', 10);
			$table->double('sub_total', 10);
			$table->double('tax', 10);
			$table->double('tax_percentage', 11)->nullable();
			$table->double('commission', 11)->nullable();
			$table->double('commission_percentage', 11)->nullable();
			$table->double('total_amount', 10);
			$table->boolean('order_status_id')->comment('id of order_status tbl');
			$table->bigInteger('transaction_id')->unsigned()->nullable()->comment('id of transaction tbl');
			$table->string('delivery_code', 4)->nullable();
			$table->string('firstname', 50)->nullable();
			$table->string('lastname', 50)->nullable();
			$table->string('phone_number', 20)->nullable();
			$table->string('email', 100)->nullable();
			$table->string('address1', 200)->nullable();
			$table->string('address2', 200)->nullable();
			$table->string('city', 50)->nullable();
			$table->string('state')->nullable();
			$table->string('zipcode', 8)->nullable();
			$table->integer('address_type')->comment('1=> Home,2=>Work,3=>other');
			$table->unsignedBigInteger('delivery_person_id')->nullable();
			$table->string('latitude');
			$table->string('longitude');
			$table->string('country', 50)->nullable();
			$table->float('distance', 11);
			$table->timestamps();


			$table->foreign('restaurant_id')->references('id')->on('restaurants');
			$table->foreign('user_id')->references('id')->on('users');
			$table->foreign('delivery_person_id')->references('id')->on('delivery_persons');


		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('orders');
	}

}
