<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('carts', function(Blueprint $table)
		{
			$table->bigIncrements('id');
			$table->unsignedBigInteger('user_id')->index('user_id')->comment('id of users tbl');
			$table->unsignedBigInteger('restaurant_id')->index('restaurant_id')->comment('id of restaurant tbl');
			$table->unsignedBigInteger('address_id')->index('address_id')->comment('id of user_address tbl');
			$table->double('distance', 11)->comment('distance b/w restaurant & user address');
			$table->timestamps();

			$table->foreign('user_id')->references('id')->on('users');
			$table->foreign('restaurant_id')->references('id')->on('restaurants');
			$table->foreign('address_id')->references('id')->on('addresses');

		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('carts');
	}

}
