<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{
	public function up()
	{
		Schema::create('transactions', function (Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('txn_no');
			$table->unsignedInteger('order_id');
			$table->float('amount', 11, 2);
			$table->unsignedTinyInteger('mode', false)->comment('1=>Online,2=>COD');
			$table->unsignedTinyInteger('status', false)->comment('0=>Failed,1=>Success');
			$table->text('request')->nullable(true);
			$table->text('response')->nullable(true);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::dropIfExists('transactions');
	}
}
