<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPhoneToUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {

            $table->timestamp('verification_otp_sent_at')->nullable()->after('phone_number');
            $table->boolean('notification_status')->default(1)->after('phone_number');
            $table->timestamp('phone_number_verified')->nullable()->after('phone_number');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('phone_number_verified');
            $table->dropColumn('verification_otp_sent_at');
            $table->dropColumn('notification_status');
        });
    }
}
