<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateForceUpdateTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('update_apps', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('android_version', 15);
            $table->string('android_update_message');
            $table->string('ios_version', 15);
            $table->string('ios_update_message');
            $table->tinyInteger('force_update_ios');
            $table->tinyInteger('force_update_android');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('update_apps');
    }
}
