<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTmpMobileToUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('tmp_email', 320)->nullable()->after('email');
            $table->string('tmp_phone_number', 11)->nullable()->after('phone_number');
            $table->string('country_code', 5)->default('233')->after('tmp_email');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('tmp_phone_number');
            $table->dropColumn('country_code');
        });
    }
}
