<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRestaurantsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('restaurants', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('user_id')->unsigned()->nullable();
            $table->string('restaurant_name')->nullable();
            $table->text('restaurant_bio')->nullable();
            $table->string('restaurant_email_id')->nullable();
            $table->string('restaurant_phone_number')->nullable();
            $table->string('restaurant_profile_photo')->nullable();
            $table->text('restaurant_address')->nullable();
            $table->string('restaurant_lat')->nullable();
            $table->string('restaurant_long')->nullable();
            $table->tinyInteger('user_status')->unsigned()->default(0)->comment('1=>Unblock, 0=>Block');
            $table->tinyInteger('status')->unsigned()->default(0)->comment('1=>Active, 0=>Inactive');
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));

            $table->foreign('user_id')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('restaurants');
    }
}
