<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDeliveryPersonsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('delivery_persons', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('user_id')->unsigned()->nullable();
            $table->integer('age')->nullable();
            $table->string('id_proof')->nullable();
            $table->string('vehicle_info')->nullable();
            $table->string('driving_license')->nullable();
            $table->text('account_details')->nullable();
            $table->tinyInteger('status')->unsigned()->default(0)->comment('1=>Active, 0=>Inactive');
            $table->tinyInteger('is_approved')->unsigned()->default(0)->comment('0=>Need to approve from admin end, 1=>Approved , 2=>Rejected ');
            $table->text('reject_reason')->nullable();
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));

            $table->foreign('user_id')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('delivery_persons');
    }
}
