<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNotificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->Integer('notifiable_module_id')->unsigned();
            $table->smallInteger('notification_type_id')->nullable()->unsigned()->comment('notification type or category');
            $table->bigInteger('notifiable_id')->unsigned()->nullable()->comment("referenced module's entity id");
            $table->bigInteger('user_id')->unsigned()->nullable()->index('name')->comment("receiver id");
            $table->bigInteger('notified_by_id')->unsigned()->nullable()->comment("sender id");
            $table->string('bold_string', 100)->nullable();
            $table->string('title')->nullable();
            $table->string('message', 1000)->nullable();
            $table->bigInteger('left_image_id')->nullable()->unsigned()->comment('left image (refered by) in alert list');
            $table->bigInteger('right_image_id')->unsigned()->nullable()->comment('right(refered to) image in alert list');
            $table->tinyInteger('is_read')->unsigned()->default(0);
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));

            $table->foreign('notifiable_module_id')->references('id')->on('modules');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
}
