<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateModulesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('modules', function (Blueprint $table) {
            $table->integerIncrements('id');
            $table->smallInteger('sort_order')->nullable();
            $table->string('name', 50)->nullable()->index('name');
            $table->string('title')->nullable();
            $table->bigInteger('parent_id')->unsigned()->nullable();
            $table->string('controller', 50)->nullable();
            $table->string('path')->nullable();
            $table->string('action', 30)->nullable();
            $table->string('icon_class', 50)->nullable();
            $table->tinyInteger('is_display_menu')->default(0);
            $table->tinyInteger('status')->unsigned()->default(0)->comment('1=>Active, 0=>Inactive');
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('modules');
    }
}
