<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStaticPagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('static_pages', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->string('title')->nullable();
            $table->string('url', 50)->nullable(); 
            $table->string('slug', 100)->nullable();
            $table->string('meta_title')->nullable()->index('meta_title');
            $table->string('meta_description')->nullable();
            $table->text('content')->nullable();
            $table->tinyInteger('status')->unsigned()->default(0)->comment('1=>Active, 0=>Inactive');
            $table->bigInteger('created_by')->unsigned()->nullable();
            $table->bigInteger('updated_by')->unsigned()->nullable();
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('static_pages');
    }
}
