<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AlterCriderStatusToRiders extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('riders', function (Blueprint $table) {
            $table->dropColumn('work_status');
        });
        Schema::table('riders', function (Blueprint $table) {
            $table->boolean('work_status')->default(0)->after('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('riders', function (Blueprint $table) {
            Schema::table('riders', function (Blueprint $table) {
                $table->dropColumn('work_status');
            });
            Schema::table('riders', function (Blueprint $table) {
                $table->enum('work_status',['online','offline'])->default('offline');
            });

        });
    }
}
