<?php

/**
 * Author: NMG
 * Description: Single place for constants used in user registration/form prcocess
 * Dated: 10/Dec/2019
 */
return [
    'EXPIR' => [
        'MINUTES' => [
            'TOKEN' => 300,
            'EMAIL_OTP' => 30,
            'REFRESH' => 9000,
            'ACCESS' => 54000,
        ],
        'DAYS' => [
            'TOKEN' => 1,
            'REFRESH' => 30,
            'ACCESS' => 180,
        ],
        'MONTH' => [
            'TOKEN' => 1,
            'REFRESH' => 3,
            'ACCESS' => 6,
        ],
    ],
    'DEFAULT_PAGE_LIMIT' => 10,
    'httpCodes' => [
        'SUCCESS' => 200,
        'ERROR' => 400,
        'BAD_REQUEST' => 400,
        'SESSION_EXPIRE' => 401,
        'UNAUTHORIZED' => 401,
        'FORBIDDEN' => 403,
        'NOT_FOUND' => 404,
        'METHOD_NOT_ALLOWED' => 405,
        'UNPROCESSABLE_ENTITY' => 422,
        'SERVER_ERROR' => 500,
        'SERVICE_UNAVAILABLE' => 503,
    ],
    'validationErrorCode' => 403,

    'EXCEPTION' => [
        'ENCRYPTION' => [
            'CODE' => 111,
        ],
    ],
    'user' => [
        'APP_USER_ROLE' => 3,
        'email' => [
            'maxLength' => 320,
        ],
        'phone_number' => [
            'maxLength' => 10,
        ],
        'voipToken' => [
            'maxLength' => 255,
        ],
        'password' => [
            'minLength' => 8,
            'maxLength' => 20,
            'regex' => '/^(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9]).*$/',
        ],
        'userName' => [
            'minLength' => 1,
            'maxLength' => 33,
            'regex' => '/^[A-Za-z0-9-_ ]+$/',
        ],
        'firstName' => [
            'minLength' => 1,
            'maxLength' => 16,
            'regex' => '/^[A-Za-z0-9_-]+$/',
        ],
        'lastName' => [
            'minLength' => 1,
            'maxLength' => 16,
            'regex' => '/^[A-Za-z0-9_-]+$/',
        ],
        'avatar' => [
            'mimes' => 'jpeg,jpg,png,gif,svg',
            'size' => 51200,
        ],
        'otp' => [
            'minLength' => 4,
        ],
        'type' => [
            'minLength' => 1,
        ],
        'media' => [
            'maxLength' => 32768,
        ],
        'countryCode' => [
            'default' => env('DEFAULT_COUNTRY_CODE', 233), // DEFAULT COUNTRY_CODE 91(India) in dev server and 233 in  staging and live server
        ]
    ],
    'contactSupport' => [
        'message' => [
            'minLength' => 2,
            'maxLength' => 400,
            'regex' => '/^(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9]).*$/',
        ],
    ],
    'address' => [
        'contact_person' => [
            'minLength' => 2,
            'maxLength' => 200,
        ],
        'address1' => [
            'minLength' => 2,
            'maxLength' => 500
        ],
        'address2' => [
            'minLength' => 2,
            'maxLength' => 1000
        ],
        'city' => [
            'minLength' => 2,
            'maxLength' => 225
        ],
        'state' => [
            'minLength' => 2,
            'maxLength' => 225
        ],
    ],
    'cart' => [
        'addressId' => [
            'minLength' => 1,
            'maxLength' => 100,
        ],
        'itemId' => [
            'minLength' => 1,
            'maxLength' => 100
        ],
        'itemQty' => [
            'minLength' => 1,
            'maxLength' => 1000
        ],
    ],
    'push_notification' => [
        'actionId' => [
            'rider_order_details' => 1,
            'customer_order_details' => 2,
            'rider_profile' => 3,
            'cart_details' => 4,
            'rider_online_offline' => 5,
            'restaurant_online_offline' => 6,
        ],
        'title' => [
            'rider_updated' => 'Delivery person has been changed',
            'rider_new_order' => 'New order request',
            'rider_in_queue' => 'Finding nearest delivery person',
        ],
        'description' => [
            'rider_updated' => 'Delivery person has been changed',
            'rider_new_order' => 'You have a new order request',
            'rider_in_queue' => 'Finding nearest delivery person',
        ]
    ]
];
