<?php

/**
 * Author: NMG
 * Description: All the files storage paths defined for api use
 * Dated: 29/Nov/2019
 */
if (env('S3_ENABLED') == true) {
    define('LOCAL_STORAGE_PATH', '');
} else {
    define('LOCAL_STORAGE_PATH', storage_path('app/public/'));
}
if (env('S3_ROOT_DIRECTORY') == true) {
    define('ROOT_DIRECTORY', env('S3_ROOT_DIRECTORY', 'uploads'));
} else {
    define('ROOT_DIRECTORY', 'uploads');
}

return [
    'ADMIN_BASE_URL' => env('ADMIN_URL'),
    'VENDOR_BASE_URL' => env('VENDOR_URL'),
    'BASE_URL' => env('APP_URL'),
    'VENDOR_URL' => env('VENDOR_APP_URL'),

    'STORAGE_DIR' => LOCAL_STORAGE_PATH,
    'UPLOAD_DIR' => ROOT_DIRECTORY,
    'avatar' => [
        'DIR' => 'avatar',
        'RESTAURANT_DIR' => 'restaurant',
        'DELIVERYP_DOC_DIR' => 'delivery_person_doc',
        'FOOD_CATEGORY_DOC_DIR' => 'food_category',
        'RESTAURANT_ITEM_DIR' => 'restaurant_item_doc',
        'RESIZE' => true,
        'RESIZE_PREFIX' => 'rsz',
        'RESIZE_WIDTH' => env('AVATAR_RESIZE_WIDTH', 600),
        'RESIZE_HEIGHT' => env('AVATAR_RESIZE_HEIGHT', 600),

        'THUMB' => true,
        'THUMB_PREFIX' => 'tmb',
        'THUMB_WIDTH' => env('AVATAR_THUMB_WIDTH', 240),
        'THUMB_HEIGHT' => env('AVATAR_THUMB_HEIGHT', 240),

        'DEFAULT_URL' => env('APP_URL') . '/public/images/admin/avatar.png',
        'RESTAURANT_DEFAULT_IMAGE' => env('APP_URL') . '/public/images/admin/no-image.png',
        'BASE_URL' => env('APP_URL') . 'public/storage/uploads/avatar',
    ],
    'facilityLogo' => [
        'DIR' => 'avatar',

        'RESIZE' => true,
        'RESIZE_PREFIX' => 'rsz',
        'RESIZE_WIDTH' => env('AVATAR_RESIZE_WIDTH', 600),
        'RESIZE_HEIGHT' => env('AVATAR_RESIZE_HEIGHT', 600),

        'THUMB' => true,
        'THUMB_PREFIX' => 'tmb',
        'THUMB_WIDTH' => env('AVATAR_THUMB_WIDTH', 240),
        'THUMB_HEIGHT' => env('AVATAR_THUMB_HEIGHT', 240),

        'DEFAULT_URL' => env('APP_URL') . 'public/images/admin/avatar.png',
        'BASE_URL' => env('APP_URL') . 'public/storage/uploads/avatar',
    ],
    'media' => [
        'DIR' => 'media',
        'RESIZE' => true,
    ],
    'staticPages' => [
        'DIR' => 'static-pages',

        'RESIZE' => true,
        'RESIZE_PREFIX' => 'rsz',
        'RESIZE_WIDTH' => env('FACILITY_LOGO_RESIZE_WIDTH', 600),
        'RESIZE_HEIGHT' => env('FACILITY_LOGO_RESIZE_HEIGHT', 600),

        'THUMB' => true,
        'THUMB_PREFIX' => 'tmb',
        'THUMB_WIDTH' => env('FACILITY_LOGO_THUMB_WIDTH', 240),
        'THUMB_HEIGHT' => env('FACILITY_LOGO_THUMB_HEIGHT', 240),

        'DEFAULT_URL' => env('APP_URL') . 'public/images/admin/avatar.png',
        'BASE_URL' => env('APP_URL') . 'public/storage/uploads/static-pages',
    ],
    'emailTemplate' => [
        'DIR' => 'email-templates',

        'RESIZE' => true,
        'RESIZE_PREFIX' => 'rsz',
        'RESIZE_WIDTH' => env('FACILITY_LOGO_RESIZE_WIDTH', 600),
        'RESIZE_HEIGHT' => env('FACILITY_LOGO_RESIZE_HEIGHT', 600),

        'THUMB' => true,
        'THUMB_PREFIX' => 'tmb',
        'THUMB_WIDTH' => env('FACILITY_LOGO_THUMB_WIDTH', 240),
        'THUMB_HEIGHT' => env('FACILITY_LOGO_THUMB_HEIGHT', 240),

        'DEFAULT_URL' => env('APP_URL') . 'public/images/admin/avatar.png',
        'BASE_URL' => env('APP_URL') . 'public/storage/uploads/email-templates',
    ],

    'mailbox' => [
        'DIR' => 'mailbox',

        'RESIZE' => true,
        'RESIZE_PREFIX' => 'rsz',
        'RESIZE_WIDTH' => env('FACILITY_LOGO_RESIZE_WIDTH', 600),
        'RESIZE_HEIGHT' => env('FACILITY_LOGO_RESIZE_HEIGHT', 600),

        'THUMB' => true,
        'THUMB_PREFIX' => 'tmb',
        'THUMB_WIDTH' => env('FACILITY_LOGO_THUMB_WIDTH', 240),
        'THUMB_HEIGHT' => env('FACILITY_LOGO_THUMB_HEIGHT', 240),

        'DEFAULT_URL' => env('APP_URL') . 'public/images/admin/avatar.png',
        'BASE_URL' => env('APP_URL') . 'public/storage/uploads/mailbox',
    ],
];
