<?php

/**
 * Author: NMG: PR
 * Description: Single place for common constants throught the admin panel only
 * Dated: 20/Nov/2019
 */
return [
    'BOLD_TITLE_SHORT' => 'BMF',
    'BOLD_TITLE' => 'BMF',
    'REGULAR_TITLE' => 'Admin',
    'SUPER_ADMIN_ROLE' => 1,
    'RESTAURANT_OWNER_ROLE' => 2,
    'PUBLIC_USERS_ROLE' => 3,
    'DELIVERY_PERSON_ROLE' => 4,
    'PAGE_LIMITS' => [10, 25, 50, 100],
    'RESET_TOKEN_EXPIRE' => 150, //MINUTES
    'DEFAULT_PAGE_LIMIT' => 10,
    'ADMIN_ROUTE_NAME' => 'secureadmin',
    'RESTAURANT_ROUTE_NAME' => 'securerestaurant',
    'SuperAdminRole' => 1,
    'userRoleAdmin' => 'Super Administrator',
    'AdminPageSize' => 10,
    'EmptyNotation' => 'N/A',
    'ENCRYPT_SECRET_KEY' => 'app-He5bjh6OG9ub00vTJ2',
    'ENCRYPT_SECRET_KEY_iv' => 'app-KlnAryanZoiLwQGrGe',
    'COUNTRY_CODE' => '+233',
    'ORDER_STATUS_PENDING' => 1,
    'ORDER_STATUS_ACCEPTED' => 2,
    'ORDER_STATUS_REJECTED' => 3,
    'ORDER_STATUS_IN_PREP' => 4,
    'ORDER_STATUS_ON_THE_WAY' => 5,
    'ORDER_STATUS_COMPLETED' => 6,
    'ORDER_STATUS_CANCELED' => 7,
    'DELIVERY_PERSON_AVAILABILITY_RANGE' => 5, // in miles
    'CURRENCY' => 'GH₵',


    'AdminAllowedBasicActions' => [
        'login' => 'AdminController',
        'logout' => 'AdminController',
        'dashboard' => 'AdminController',
        'myProfile' => 'AdminController',
        'changePassword' => 'AdminController',
        'update_status' => 'BaseController',
        'forgot-password' => 'AdminController',
    ],
    'VendorAllowedBasicActions' => [
        'login' => 'VendorController',
        'logout' => 'VendorController',
        'dashboard' => 'VendorController',
        'myProfile' => 'VendorController',
        'changePassword' => 'VendorController',
        'update_status' => 'BaseController',
        'forgot-password' => 'VendorController',
    ],

    'STATUS' => [
        1 => 'Active',
        0 => 'Inactive',
    ],

    'user' => [
        'user_name' => [
            'minLength' => 1,
            'maxLength' => 16,
            'regex' => '^[A-Za-z0-9_-]+$',
            'sregex' => '/^[A-Za-z0-9_-]+$/',
        ],
        'email' => [
            'minLength' => 1,
            'maxLength' => 50,
            'regex' => "\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$",
        ],
        'phone_number' => [
            'minLength' => 10,
            'maxLength' => 10,
            'regex' => '^([\(]{1}[0-9]{3}[\)]{1}[ |\-]{0,1}|^[0-9]{3}[\-| ])?[0-9]{3}(\-| ){1}[0-9]{4}$',
            'sregex' => '/^([\(]{1}[0-9]{3}[\)]{1}[ |\-]{0,1}|^[0-9]{3}[\-| ])?[0-9]{3}(\-| ){1}[0-9]{4}$/',
        ],
        'mobile_no' => [
            'minLength' => 10,
            'maxLength' => 10,
            'regex' => '^([\(]{1}[0-9]{3}[\)]{1}[ |\-]{0,1}|^[0-9]{3}[\-| ])?[0-9]{3}(\-| ){1}[0-9]{4}$',
            'sregex' => '/^([\(]{1}[0-9]{3}[\)]{1}[ |\-]{0,1}|^[0-9]{3}[\-| ])?[0-9]{3}(\-| ){1}[0-9]{4}$/',
        ],
        'password' => [
            'minLength' => 8,
            'maxLength' => 16,
            'regex' => '^(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9]).*$',
            'sregex' => '/^(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9]).*$/',
        ],
        'first_name' => [
            'minLength' => 1,
            'maxLength' => 16,
            'regex' => '^[A-Za-z0-9_-]+$',
            'sregex' => '/^[A-Za-z0-9_-]+$/',
        ],
        'last_name' => [
            'minLength' => 1,
            'maxLength' => 16,
            'regex' => '^[A-Za-z0-9_-]+$',
            'sregex' => '/^[A-Za-z0-9_-]+$/',
        ],

        'avatar' => [
            'mimes' => 'jpeg,jpg,png,gif,svg',
            'size' => 51200,
        ],
        'doc' => [
            'mimes' => 'jpeg,jpg,png,gif,svg,pdf',
            'size' => 51200,
        ],
        'audio' => [
            'mimes' => 'mp3,mp4,m4a',
            'size' => 51200,
        ],
    ],
    'restaurant' => [

        'restaurant_email_id' => [
            'minLength' => 1,
            'maxLength' => 50,
            'regex' => "\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$",

        ],
        'phone_number' => [
            'minLength' => 10,
            'maxLength' => 10,
            'regex' => '^([\(]{1}[0-9]{3}[\)]{1}[ |\-]{0,1}|^[0-9]{3}[\-| ])?[0-9]{3}(\-| ){1}[0-9]{4}$',
            'sregex' => '/^([\(]{1}[0-9]{3}[\)]{1}[ |\-]{0,1}|^[0-9]{3}[\-| ])?[0-9]{3}(\-| ){1}[0-9]{4}$/',
        ],
        'restaurant_name' => [
            'minLength' => 1,
            'maxLength' => 100,
            'regex' => '^[A-Za-z0-9_- ]+$',
            'sregex' => '/^[A-Za-z0-9_- ]+$/',
        ],
        'restaurant_bio' => [
            'minLength' => 1,
            'maxLength' => 300,
            'regex' => '^[A-Za-z0-9_- ]+$',
            'sregex' => '/^[A-Za-z0-9_- ]+$/',
        ],
        'restaurant_address' => [
            'minLength' => 1,
            'maxLength' => 100,
            'regex' => '^[A-Za-z0-9_- ]+$',
            'sregex' => '/^[A-Za-z0-9_- ]+$/',
        ],
        'avatar' => [
            'mimes' => 'jpeg,jpg,png,gif,svg',
            'size' => 51200,
        ],
        'otp' => [
            'minLength' => 4,
            'maxLength' => 4,
        ],
        'deliverytime' => [
            'regex' => '^[0-6][0-9]-[0-6][0-9]$'
        ]

    ],
    'delivery-person' => [
        'age' => [
            'minLength' => 2,
            'maxLength' => 2,
            'regex' => '^[0-9_-]+$',
            'sregex' => '/^[0-9_-]+$/',
        ],
        'phone_number' => [
            'minLength' => 10,
            'maxLength' => 10,
            'regex' => '^[0-9_-]+$',
            'sregex' => '/^[0-9_-]+$/',
        ],

        'id_proof' => [
            'minLength' => 1,
            'regex' => '^[A-Za-z0-9_-]+$',
            'sregex' => '/^[A-Za-z0-9_-]+$/',
        ],

        'vehicle_info' => [
            'minLength' => 1,
            'regex' => '^[A-Za-z0-9_-]+$',
            'sregex' => '/^[A-Za-z0-9_-]+$/',
        ],

        'account_details' => [
            'minLength' => 1,
            'regex' => '^[A-Za-z0-9_-]+$',
            'sregex' => '/^[A-Za-z0-9_-]+$/',
        ],
        'account_number' => [
            'minLength' => 1,
            'regex' => '^[A-Za-z0-9_-]+$',
            'sregex' => '/^[A-Za-z0-9_-]+$/',
        ],
        'bank_name' => [
            'minLength' => 1,
            'regex' => '^[A-Za-z0-9_-]+$',
            'sregex' => '/^[A-Za-z0-9_-]+$/',

        ],

        'driving_license' => [
            'minLength' => 1,
            'regex' => '^[A-Za-z0-9_-]+$',
            'sregex' => '/^[A-Za-z0-9_-]+$/',
        ],


    ],
    'restaurant-menu' => [
        'name' => [
            'minLength' => 1,
            'maxLength' => 80,
            'regex' => '^[A-Za-z0-9_- ]+$',
            'sregex' => '/^[A-Za-z0-9_- ]+$/',
        ],

        'description' => [
            'minLength' => 1,
            'maxLength' => 100,
            'regex' => '^[A-Za-z0-9_-]+$',
            'sregex' => '/^[A-Za-z0-9_-]+$/',
        ],

        'price' => [
            'minLength' => 1,
            'regex' => '^\d+(\.\d+)*$',
            'sregex' => '^\d+(\.\d+)*$',
        ],

        'prep_time' => [
            'minLength' => 1,
            'regex' => '^[0-9]*$',
            'maxLength' => 2,
        ],
        'image' => [
            'mimes' => 'jpeg,jpg,png,gif,svg',
            'size' => 51200,
        ],



    ],
    'general-setting' => [
        'tax' => [
            'minLength' => 1,
            'maxLength' => 5,
            'regex' => '^[1-9][0-9]?$|^99$',
            'sregex' => '^[1-9][0-9]?$|^99$',
        ],

        'delivery_charge' => [
            'minLength' => 1,
            'maxLength' => 2,
            'regex' => '^[0-9_-]+$',
            'sregex' => '/^[0-9_-]+$/',
        ],

        'admin_commison' => [
            'minLength' => 1,
            'maxLength' => 5,
            'regex' => '^[1-9][0-9]?$|^99$',
            'sregex' => '^[1-9][0-9]?$|^99$',
        ],

    ],
    'category' => [
        'name' => [
            'minLength' => 1,
            'maxLength' => 20,
            'regex' => '^[a-zA-Z0-9_- ]+$',
            'sregex' => '/^[a-zA-Z0-9_- ]+$/',
        ],



    ],
    'role' => [
        'name' => [
            'minLength' => 1,
            'maxLength' => 30,
            'regex' => '^[a-zA-Z0-9-_ ]+$',
            'sregex' => '/^[a-zA-Z0-9-_ ]+$/',
        ],
        'description' => [
            'minLength' => 1,
            'maxLength' => 500,
        ],
    ],
    'static-page' => [
        'content' => [
            'minLength' => 2,
            'maxLength' => 5000,
        ],
        'meta_title' => [
            'minLength' => 1,
            'maxLength' => 255,
        ],
        'meta_description' => [
            'minLength' => 1,
            'maxLength' => 255,
        ],
    ],
    'contact-us' => [

        'message' => [
            'minLength' => 1,
            'maxLength' => 400,
        ],
    ],
    'contact-title' => [
        'name' => [
            'minLength' => 1,
            'maxLength' => 50,
        ],
    ],

    'email-template' => [
        'subject' => [
            'minLength' => 1,
            'maxLength' => 250,
        ],
        'content' => [
            'minLength' => 1,
            'maxLength' => 2000,
        ],
    ],

    'smtp-setting' => [
        'driver' => [
            'minLength' => 1,
            'maxLength' => 50,
        ],
        'host' => [
            'minLength' => 1,
            'maxLength' => 50,
        ],
        'port' => [
            'minLength' => 1,
            'maxLength' => 3,
        ],
        'username' => [
            'minLength' => 1,
            'maxLength' => 50,
        ],
        'password' => [
            'minLength' => 1,
            'maxLength' => 50,
        ],
        'encryption' => [
            'minLength' => 1,
            'maxLength' => 50,
        ],
    ],
    'global-setting' => [
        'value' => [
            'minLength' => 1,
            'maxLength' => 100,
        ],
    ],
    'blocked-reason' => [
        'reason' => [
            'minLength' => 1,
            'maxLength' => 100,
        ],
    ],
    'mailbox' => [
        'email' => [
            'regex' => '^(\s?[^\s,]+@[^\s,]+\.[^\s,]+\s?,)*(\s?[^\s,]+@[^\s,]+\.[^\s,]+)$',
        ],
        'subject' => [
            'minLength' => 1,
            'maxLength' => 100,
        ],
        'push_title' => [
            'minLength' => 1,
            'maxLength' => 40,
        ],
        'push_content' => [
            'minLength' => 1,
            'maxLength' => 100,
        ],
    ],
    'app-version' => [
        'android_version' => [
            'minLength' => 1,
            'maxLength' => 10,
            'regex' => '^[1-9][\.\d]*(,\d+)?$',
        ],
        'ios_version' => [
            'minLength' => 1,
            'maxLength' => 10,
            'regex' => '^[0-9][0-9.]*$',
        ],
        'android_update_message' => [
            'minLength' => 1,
            'maxLength' => 300,
        ],
    ],

];
