<?php

use app\Model\Admin\AdminRole;
use app\Model\Admin\Department;
use app\Model\Admin\GlobalSetting;
use app\Model\Admin\User;
use Illuminate\Support\Facades\Storage;

/**
 * Author: NMG
 * Function: getConfig
 * Description: Get Configuration value by key
 * Input: null
 * Output: retrun array or null
 * Dated: 24/12/2019
 */
if (!function_exists('getConfig')) {

    function getConfig($slug)
    {
        $config = GlobalSetting::where(['slug' => $slug, 'status' => '1'])->first();
        if (!empty($config)) {
            return $config->value;
        } else {
            return '';
        }
    }
}

/**
 * Author: NMG
 * Function: getRole
 * Description: Get role value by key
 * Input: null
 * Output: retrun array or null
 * Dated: 24/12/2019
 */
if (!function_exists('getRole')) {

    function getRole($rollId)
    {
        $roll = AdminRole::where(['id' => $rollId, 'status' => '1'])->first();
        if (!empty($roll)) {
            return $roll->name;
        } else {
            return '';
        }
    }
}

/**
 * Author: NMG
 * Function: deleteDir
 * Description: delete directory recursively
 * Input: null
 * Output: retrun array or null
 * Dated: 13/01/2020
 */
function deleteDir($dirPath)
{

    if (env('S3_ENABLED') == true) {
        // 
        Storage::disk('s3')->deleteDirectory($dirPath);
    } else {
        if (!is_dir($dirPath)) {
            throw new InvalidArgumentException("$dirPath must be a directory");
        }
        if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
            $dirPath .= '/';
        }
        $files = glob($dirPath . '*', GLOB_MARK);
        foreach ($files as $file) {
            if (is_dir($file)) {
                deleteDir($file);
            } else {
                unlink($file);
            }
        }
        rmdir($dirPath);
    }
}

/**
 * Author: NMG
 * Function: isOwner
 * Description: check is owner or not
 * Input: null
 * Output: retrun boolean true or false
 * Dated: 13/01/2020
 */
if (!function_exists('isOwner')) {

    function isOwner($row = null)
    {
        $authUser = Auth::guard('admin')->user();
        $authUserId = (int) $authUser->id;
        $authRoleId = (int) $authUser->role_id;
        $role = \app\Model\Admin\Role::select('is_super_admin')->where('id', $authRoleId)->first();
        if ($role->is_super_admin == 1) {
            return true;
        } else {
            if ($row->created_by == $authUserId) {
                return true;
            }
        }

        return false;
    }
}

/**
 * Author: NMG
 * Function: getFullName
 * Description: get full name by user id
 * Input: null
 * Output: retrun string name
 * Dated: 13/01/2020
 */
if (!function_exists('getFullName')) {

    function getFullName($userId)
    {
        if (!empty($userId)) {
            $user = \app\Model\Admin\User::where('id', $userId)->first();
            return !empty($user->fullName) ? $user->fullName : 'N\A';
        } else {
            return 0;
        }
    }
}

/**
 * Author: NMG
 * Function: getdeptName
 * Description: get name by user id
 * Input: null
 * Output: retrun string name
 * Dated: 18/03/2020
 */
if (!function_exists('getdeptName')) {

    function getdeptName($deptId)
    {
        if (!empty($deptId)) {
            $dept = \app\Model\Admin\Department::where('id', $deptId)->first();
            return !empty($dept->name) ? $dept->name : 'N\A';
        } else {
            return 0;
        }
    }
}

/**
 * Author: NMG
 * Function: deptList
 * Description: get full name by user id
 * Input: null
 * Output: retrun string name
 * Dated: 13/01/2020
 */
if (!function_exists('deptList')) {

    function deptList($deptId = null, $pId = null, $space = '')
    {
        if (\Auth::guard('admin')->user()->role_id == config('admin.constants.SUB_ADMIN_ROLE')) {

            $q = Department::where([
                ['parent_id', '=', $pId],
                ['status', '=', 1],
                ['facility_id', '=', \Auth::guard('admin')->user()->facility_id],
            ])->get();
        } else {
            $q = Department::where(['status' => 1, 'parent_id' => $pId])->get();
        }

        if ($pId == null) {
            $space = '';
        } else {
            $space .= "&nbsp;&nbsp;&nbsp;&nbsp;";
        }
        if (count($q)) {
            foreach ($q as $val) {
                if ((!empty($deptId) && $val['id'] == $deptId) || !empty(app('request')->input('department_id') && app('request')->input('department_id') == $val['id'])) {
                    $select = 'selected';
                } else {
                    $select = '';
                }
                echo "<option " . $select . " value=" . $val['id'] . ">" . $space . $val['name'] . "</option>";
                deptList($deptId, $val['id'], $space);
            }
        }
    }
}

/**
 * Author: NMG
 * Function: iosNotification
 * Description: send notification to ios device
 * Input: null
 * Output: retrun string name
 * Dated: 05/02/2020
 */
if (!function_exists('iosNotification')) {

    function iosNotification($voipToken, $passphrase = null, $message = null, $pemPath)
    {
        $ctx = stream_context_create();
        stream_context_set_option($ctx, 'ssl', 'local_cert', $pemPath);
        stream_context_set_option($ctx, 'ssl', 'passphrase', $passphrase);

        // Open a connection to the APNS server
        $fp = stream_socket_client(
            'ssl://gateway.sandbox.push.apple.com:2195',
            $err,
            $errstr,
            60,
            STREAM_CLIENT_CONNECT | STREAM_CLIENT_PERSISTENT,
            $ctx
        );

        if (!$fp) {
            exit("Failed to connect: $err $errstr" . PHP_EOL);
        }

        //echo 'Connected to APNS' . PHP_EOL;

        // Create the payload body
        $body['aps'] = array(
            'alert' => $message,
            'sound' => 'default',
        );

        // Encode the payload as JSON
        $payload = json_encode($body);

        // Build the binary notification
        $msg = chr(0) . pack('n', 32) . pack('H*', $voipToken) . pack('n', strlen($payload)) . $payload;

        // Send it to the server
        $result = fwrite($fp, $msg, strlen($msg));

        if (!$result) {
            return false;
            //return 'Message not delivered' . PHP_EOL;
        } else {
            return true;
            //return 'Message successfully delivered' . PHP_EOL;
        }

        // Close the connection to the server
        fclose($fp);
    }
}
