<?php

namespace app\Transformers;

use app\Enums\ApprovalType;
use app\Transformers\BaseTransformer;

class RiderTransformer extends BaseTransformer
{

    /**
     * transformer method for eloquent object.
     *
     * @param [object] $address
     * @return void
     */
    public function transform($data)
    {
        return [
            "id"                 => $data->id,
            "userId"            => $data->user_id,
            "fullName"          => trim($data->user->first_name . ' ' . $data->user->last_name),
            "email"              => $data->user->email,
            "profileImage"      => $data->user->profile_image,
            "isDeliveryPerson" => (bool) $data->user->is_delivery_person,
            "isOnline"          => $data->user->is_active == 1 ? true : false,
            "phoneNumber"       => $data->user->phone_number,
            "age"                => $data->age,
            "idProof"           => $data->id_proof,
            "vehicleInfo"       => $data->vehicle_info,
            "drivingLicense"    => $data->driving_license,
            "bankName"          => $data->bank_name,
            "accountNumber"    => $data->account_number,
            "workStatus"        => $data->work_status == 1 ? "occupied" : "available",
            "isActive"        => (bool) $data->status,
            // "status"             => ApprovalType::getKey((int) $data->status),
            "status"             => (int) $data->is_approved
        ];
    }
}
