<?php

namespace app\Transformers;

use app\Model\Api\v1\Restaurant;
use app\Model\Admin\GeneralSetting;
use app\Transformers\BaseTransformer;
use app\Traits\DistanceCalculatorTrait;

class RestaurantTransformer extends BaseTransformer
{

    /**
     * transformer method for eloquent object.
     *
     * @param [object] $address
     * @return void
     */
    public function transform($data)
    {
        $restType = [];
        $imageHeight = request()->header('height');
        $imageWidth = request()->header('width');

        if ($data->resturent_type_local == 1) {
            $restType[] = 1;
        }
        if ($data->resturent_type_continental == 1) {
            $restType[] = 2;
        }
        if ($data->resturent_type_groceries == 1) {
            $restType[] = 3;
        }

        // $distance = (float) DistanceCalculatorTrait::distanceOneToOne(request()->latitude, request()->longitude, $data->latitude, $data->longitude);
        $distance = DistanceCalculatorTrait::distanceOneToOneApi(request()->latitude, request()->longitude, $data->latitude, $data->longitude);

        $fixedDeliveryCharge = GeneralSetting::getDeliveryCharges();
        $perMileCharges = GeneralSetting::getMileCharges();

        // GET DISTINCT FOOD CATEGORIES
        $foodCat = Restaurant::getDistinctFoodCategories($data->id);


        // get latest avatar image
        $userAvatar = \app\Model\Admin\UserAvatars::where(['user_id' => $data->owner_id])->latest();

        if (!empty($imageHeight) || !empty($imageWidth)) { // setup lambda images.
            $restaurantImage = (!empty($userAvatar->first()) ? \app\Helpers\ResizeImagesHelper::resizeImage($userAvatar->first()->avatar) : '');
        } else {
            $restaurantImage = (!empty($userAvatar->first()) ? $userAvatar->first()->avatar : '');
        }

        return [
            "id"             => $data->id,
            "name"        => $data->name,
            "bio"        => $data->bio,
            "address"        => $data->address1,
            "categoryTypes" => $foodCat,
            "lat" => $data->latitude,
            "long" => $data->longitude,
            "restaurantType"       => implode(',', $restType),
            "deliveryTime"       => (!empty($data->delivery_time) ? $data->delivery_time . ' min' : '15-30 min'),
            "distance"       => (float) $distance,
            // "deliveryFee"           => ($fixedDeliveryCharge + ($perMileCharges * $distance)),
            "deliveryFee"           => \app\Helpers\CommonHelper::calculateDeliveryFees($distance),
            "restaurantImage"       => $restaurantImage,
        ];
    }
}
