<?php

namespace app\Transformers;

// use app\Enums\AddressType;
use app\Transformers\BaseTransformer;

class RestaurantMenuTransformer extends BaseTransformer
{

    /**
     * transformer method for eloquent object.
     *
     * @param [object] $address
     * @return void
     */
    public function transform($data)
    {
        $imageHeight = request()->header('height');
        $imageWidth = request()->header('width');

        if(!empty($imageHeight) || !empty($imageWidth)){ // setup lambda images.
            $rstMenuImage = (!empty($data->image) ? \app\Helpers\ResizeImagesHelper::resizeImage($data->image) : '');
        }else{
            $rstMenuImage = (!empty($data->image) ? $data->image : '');
        }

        return [
            "id"             => $data->id,
            "restaurantId"   => $data->restaurant_id,
            "foodCategoryId" => $data->food_category_id,
            "name"       => $data->name,
            "image"       => $rstMenuImage,
            "price"       => $data->price,
            "prepTime"        => $data->prep_time,
            "allergyAdvice"   => $data->allergy_advice,
            "description"     => $data->description,
            "isActive"        => (bool) $data->status,
        ];
    }

    // /**
    //  * get meta info from pagination class.
    //  * @param [type] $collection
    //  */
    // public  function collection($collection, $pagination = false)
    // {
    //     $result       = new \StdClass();
    //     $result->data = $this->transformCollection($collection, false);

    //     return $result;
    // }
}
