<?php

namespace app\Transformers;

use app\Enums\AddressType;
use app\Transformers\BaseTransformer;

class OrderTransformer extends BaseTransformer
{

    /**
     * transformer method for eloquent object.
     *
     * @param [object] $address
     * @return void
     */
    public function transform($data)
    {
        $itemList = [];
        $i = 0;
        if (!empty($data->orderItem)) {
            foreach ($data->orderItem as $d) {
                $itemList[$i]['itemName'] = (string) $d->itemDetail->name;
                $itemList[$i]['itemCount'] = (string) $d->item_qty;
                $itemList[$i]['itemPrice'] = (string) $d->item_price;
                $itemList[$i]['itemImage'] = (string) $d->itemDetail->image;
                $i++;
            }
        }
        $returnData =  [
            "orderId"           => (int) $data->id,
            "deliveryCharges"   => (string) $data->delivery_charge,
            "deliveryPersonRevenue"   => (string) $data->delivery_person_revenue,
            "tax"               =>  number_format((float) ($data->tax), 2, '.', ''),
            "itemTotal"       => (string) $data->sub_total,
            "totalAmount"       => (string) $data->total_amount,
            "orderStatus"       => (string) $data->orderStatus->name,
            "orderStatusId"       => (string) $data->order_status_id,
            "deliveryCode"       => (string) $data->delivery_code,
            "orderOn"          => (int) strtotime($data->created_at),
            "itemCount"         => (int) $data->orderItem->count(),
            "itemList"          => $itemList,
            "address"           => (string) $data->address1,
            "zipcode"        => (string) $data->zipcode,
            "addressType"   => (int) $data->address_type,
            "latitude"       => (string) $data->latitude,
            "longitude"      => (string) $data->longitude,
            "phoneNumber"        => (string) $data->phone_number,
            "deliveryNote"     => (string) $data->delivery_note,
            // "updated_at"     => $data->updated_at,

        ];

        if (!empty($data->assignStatus)) {
            $returnData['orderAcceptStatus'] = (int) $data->assignStatus;
            $returnData['riderEarningAmount'] = $data->delivery_charge;
        }
        if (!empty($data->restaurant)) {
            $returnData['restaurant']['id'] = $data->restaurant->id;
            $returnData['restaurant']['name'] = (string) $data->restaurant->name;
            $returnData['restaurant']['deliveryTime'] = $data->restaurant->delivery_time;
            $returnData['restaurant']['address'] = $data->restaurant->address1;
            $returnData['restaurant']['phoneNumber'] = $data->restaurant->user->phone_number;
            $returnData['restaurant']['latitude'] = (string) $data->restaurant->latitude;
            $returnData['restaurant']['longitude'] = (string) $data->restaurant->longitude;
        }

        if (!empty($data->deliveryPerson)) {
            $returnData['deliveryPerson']['name'] = $data->deliveryPerson->user->first_name . ' ' . $data->deliveryPerson->user->last_name;
            $returnData['deliveryPerson']['image'] = $data->deliveryPerson->user->profile_image;
            $returnData['deliveryPerson']['phoneNumber'] = $data->deliveryPerson->user->phone_number;
        } else {
            $returnData['deliveryPerson'] = null;
        }
        return $returnData;
    }
}
