<?php

namespace app\Transformers;

use app\Enums\ApprovalType;
use app\Transformers\BaseTransformer;

class NotificationTransformer extends BaseTransformer
{

    /**
     * transformer method for eloquent object.
     *
     * @param [object] $address
     * @return void
     */
    public function transform($data)
    {
        return [
            "id"                   => $data->id,
            "userId"              => $data->user_id,
            "title"                => $data->title,
            "data"              => $data->description,
            "orderId"              => $data->order_id,
            "isRead"          => $data->is_read,
            "actionId"          => $data->action_id,
            "date"            => strtotime($data->created_at)
        ];
    }
}
