<?php

namespace app\Transformers;

/**
 * base class for transformers layer.
 * @author: Sumit Sharma <sumit.sharma@nmgtechnologies.com>
 * @since: 23 July 2021
 */
class BaseTransformer
{

    /**
     * base class transform collection
     *
     * @param [type] $collection
     * @return void
     */
    protected function transformCollection($collection)
    {
        return $collection->map(function ($item) {
            return $this->transform($item);
        });
    }

    public function transform($item)
    {
        return $item;
    }
    /**
     * get meta info from pagination class.
     *
     * @param [collection] $collection
     * @param optional boolean $pagination
     * @return StdClass object
     */
    public function collection($collection, $pagination = true): \StdClass
    {
        $result       = new \StdClass();
        if($pagination) {
            $result->meta = [
                'current_page'   => $collection->currentPage(),
                'first_page_url' => $collection->url(1),
                'from'           => $collection->firstItem(),
                'next_page_url'  => $collection->nextPageUrl(),
                'per_page'       => $collection->perPage(),
                'prev_page_url'  => $collection->previousPageUrl(),
                'to'             => $collection->lastItem(),
                'total'          => $collection->total(),
                "more_pages"     => $collection->hasMorePages(),
            ];
        }

        $result->data = $this->transformCollection($collection);

        return $result;
    }
}
