<?php

namespace app\Transformers;

use app\Enums\AddressType;
use app\Transformers\BaseTransformer;

class AddressTransformer extends BaseTransformer
{

    /**
     * transformer method for eloquent object.
     *
     * @param [object] $address
     * @return void
     */
    public function transform($data)
    {
        return [
            "id"             => $data->id,
            "user_id"        => $data->user_id,
            "contact_person" => $data->contact_person,
            "address1"       => $data->address1,
            "address2"       => $data->address2,
            "address2"       => $data->address2,
            "city"           => $data->city,
            "state"          => $data->state,
            "zipcode"        => $data->zipcode,
            "address_type"   => AddressType::getKey((int) $data->address_type),
            "latitude"       => $data->latitude,
            "longitude"      => $data->longitude,
            "country"        => $data->country,
            "created_at"     => $data->created_at,
            "updated_at"     => $data->updated_at,

        ];
    }

}
