<?php

namespace app\Traits;

use Illuminate\Support\Facades\Http;

trait OrderStatusTrait
{

    /**
     * Author : Jaidev
     * Method : orderStatusOptionHandler
     * Desc : handle possibility of order status that can be update according to current status
     * Date : 30/March/2022
     */
    public static function orderStatusOptionHandler($status, $orderId)
    {
        if ($status == config('admin.constants.ORDER_STATUS_IN_PREP')) {
            return ' &nbsp; <a href="' . env('ADMIN_URL') . '/order/reAssignRider/' . \Crypt::encryptString($orderId) . '" title="Re-Assign Rider" class="btn btn-primary">Re-Assign New Rider</a>';
        } else if ($status == config('admin.constants.ORDER_STATUS_ON_THE_WAY')) {
            // if status is on d way then admin can mark order status to complete
            $html = "";
            // check last delivery person assignment status // if rider rejected then enable re-assign rider option
            $lastRiderResponse = \app\Model\Api\V1\DeliveryPersonAssignment::where(['order_id' => $orderId])->latest()->first();
            if (!empty($lastRiderResponse) && $lastRiderResponse->status == 3) {
                $html .= ' &nbsp; <a href="' . env('ADMIN_URL') . '/order/reAssignRider/' . \Crypt::encryptString($orderId) . '" title="Re-Assign Rider" class="btn btn-primary">Re-Assign New Rider</a>';

                $html .= ' &nbsp; <a href="' . env('ADMIN_URL') . '/order/cancelOrder/' . \Crypt::encryptString($orderId) . '" title="Re-Assign Rider" class="btn btn-danger">Cancel Order</a>';
            } else {
                // $html .= ' &nbsp; <a href="' . env('ADMIN_URL') . '/order/reAssignRider/' . \Crypt::encryptString($orderId) . '" title="Re-Assign Rider" class="btn btn-primary">Re-Assign New Rider</a>';

                $html .= ' &nbsp; <a href="' . env('ADMIN_URL') . '/order/complete-order/' . \Crypt::encryptString($orderId) . '" title="Mark Order Complete" class="btn btn-success">Complete Order</a>';

                $html .= ' &nbsp; <a href="' . env('ADMIN_URL') . '/order/cancelOrder/' . \Crypt::encryptString($orderId) . '" title="Re-Assign Rider" class="btn btn-danger">Cancel Order</a>';
            }
            return $html;
        } else {
            return false;
        }
    }
}
