<?php
namespace app\Traits;

use app\Model\Admin\Facility;
use app\Model\Admin\User;
use app\Model\Admin\Restaurant;
use app\Model\Admin\DeliveryPersons;
use Illuminate\Http\Request;
use app\Model\Admin\GroupImage;
use app\Model\Admin\PubnubImage;
use app\Model\Admin\PubnubAudio;
use app\Model\Api\Messages;
use app\Model\Admin\UserAvatars;

trait FilePathUrl
{
    /**
     * Author: NMG
     * function: userAvatar
     * Description: Generate user image of image path by just providing user id
     * Input: user id, image_id(optional), is_url(flag)
     * output: ['key'(for s3 url generation)] or ['origioanl image', 'resized image', 'thumb image']
     * Dated: 05/September/2019
     */
    public static function userAvatar($user_id = null, $isUrl = true)
    {
        if (empty($user_id)) {
            return false;
        }

        $localStoragePath = config('admin.path.STORAGE_DIR');

        $uploadDir = config('admin.path.UPLOAD_DIR');
        $avatarDir = config('admin.path.avatar.DIR');
        //concat image name with prefixes
        $resizedPrefix = config('admin.path.avatar.RESIZE_PREFIX');
        $thumbPrefix = config('admin.path.avatar.THUMB_PREFIX');

        $originalUrl = $resizedUrl = $thumbUrl = null;

        if (is_numeric($user_id)) {
            $userAvatar = User::select('id', 'profile_image')->where('id', $user_id)->latest()->first();
            if (!empty($userAvatar->profile_image)) {
                $pathKey = $uploadDir . '/' . $avatarDir . '/' . $user_id;
                //echo $localStoragePath . '/' . $pathKey . '/' . $userAvatar->profile_image;die;
                if (env('S3_ENABLED') == true) {
                    $resizedDimensions = $thumbDimensions = '';
                    $resizedImageDimensions = request()->header('Image-Dimensions-Resized');
                    if (empty($resizedImageDimensions)) {
                        $resizedImageDimensions = config('admin.path.avatar.RESIZE_WIDTH');
                    }
                    if (!empty($resizedImageDimensions)) {
                        $keywords = explode("x", $resizedImageDimensions);
                        $resizedDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $resizedDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }
                    $thumbImageDimensions = request()->header('Image-Dimensions-Thumb');
                    if (empty($thumbImageDimensions)) {
                        $thumbImageDimensions = config('admin.path.avatar.THUMB_WIDTH');
                    }
                    if (!empty($thumbImageDimensions)) {
                        $keywords = explode("x", $thumbImageDimensions);
                        $thumbDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $thumbDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }

                    if(!empty($userAvatar->latestAvatar->avatar)){
                        $key = $pathKey . '/' . $userAvatar->latestAvatar->avatar;
                        $keyRsz = $pathKey . '/rsz_' . $userAvatar->latestAvatar->avatar;
                        $keyThumb = $pathKey . '/tmb_' . $userAvatar->latestAvatar->avatar;

                    }else{
                        $key = $pathKey . '/' . $userAvatar->profile_image;
                        $keyRsz = $pathKey . '/rsz_' . $userAvatar->profile_image;
                        $keyThumb = $pathKey . '/tmb_' . $userAvatar->profile_image;
                    }

                    if ($isUrl) {
                        // return image original, resized & thumb urls
                        $originalUrl = self::s3Uri($key);
                        $resizeUrl = self::s3Uri($keyRsz);
                        $thumbUrl = self::s3Uri($keyThumb);
                        $s3Client = \AWS::createClient('s3');
                        $response = $s3Client->doesObjectExist(config('filesystems.disks.s3.bucket'), $key);
                        if (!empty($response)) {
                            //$resizedUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $resizedDimensions;
                            $resizedUrl = $resizeUrl;
                            //$thumbUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $thumbDimensions;
                            $thumbUrl = $thumbUrl;
                        }else{
                            return null;
                        }
                    } else {
                        //return image s3 key
                        return $key;
                    }
                } else {
                    if ($isUrl) {
                        
                        if (file_exists($localStoragePath . '/' . $pathKey . '/' . $userAvatar->profile_image)) {
                            $originalUrl = url('/storage') . '/' . $pathKey . '/' . $userAvatar->profile_image;
                            $resizedUrl = url('/storage') . '/' . $pathKey . '/' . $resizedPrefix . '_' . $userAvatar->profile_image;
                            $thumbUrl = url('/storage') . '/' . $pathKey . '/' . $thumbPrefix . '_' . $userAvatar->profile_image;
                        }
                    } else {
                        return $pathKey . '/' . $userAvatar->profile_image;
                    }
                }
                if (!empty($originalUrl)) {
                    return [
                        'origional' => $originalUrl,
                        'resized' => $resizedUrl,
                        'thumb' => $thumbUrl,
                    ];
                }
            }
            return null;
        } else {
            //for api use: pass non numeric valuefor user_id
            return [
                'origional' => $originalUrl,
                'resized' => $resizedUrl,
                'thumb' => $thumbUrl,
            ];
        }
    }


    /**
     * Customer avtar
     */
    public static function customerAvatar($user_id = null, $isUrl = true)
    {
        if (empty($user_id)) {
            return false;
        }

        $localStoragePath = config('admin.path.STORAGE_DIR');

        $uploadDir = config('admin.path.UPLOAD_DIR');
        $avatarDir = config('admin.path.avatar.DIR');
        //concat image name with prefixes
        $resizedPrefix = config('admin.path.avatar.RESIZE_PREFIX');
        $thumbPrefix = config('admin.path.avatar.THUMB_PREFIX');

        $originalUrl = $resizedUrl = $thumbUrl = null;

        if (is_numeric($user_id)) {
            $userAvatar = UserAvatars::select('id' , 'user_id', 'avatar')->where('user_id', $user_id)->latest()->first();
            if (!empty($userAvatar->avatar)) {
                $pathKey = $uploadDir . '/' . $avatarDir . '/' . $user_id;
                //echo $localStoragePath . '/' . $pathKey . '/' . $userAvatar->profile_image;die;
                if (env('S3_ENABLED') == true) {
                    $resizedDimensions = $thumbDimensions = '';
                    $resizedImageDimensions = request()->header('Image-Dimensions-Resized');
                    if (empty($resizedImageDimensions)) {
                        $resizedImageDimensions = config('admin.path.avatar.RESIZE_WIDTH');
                    }
                    if (!empty($resizedImageDimensions)) {
                        $keywords = explode("x", $resizedImageDimensions);
                        $resizedDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $resizedDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }
                    $thumbImageDimensions = request()->header('Image-Dimensions-Thumb');
                    if (empty($thumbImageDimensions)) {
                        $thumbImageDimensions = config('admin.path.avatar.THUMB_WIDTH');
                    }
                    if (!empty($thumbImageDimensions)) {
                        $keywords = explode("x", $thumbImageDimensions);
                        $thumbDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $thumbDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }

                    if(!empty($userAvatar->avatar)){
                        $key = $pathKey . '/' . $userAvatar->avatar;
                        $keyRsz = $pathKey . '/rsz_' . $userAvatar->avatar;
                        $keyThumb = $pathKey . '/tmb_' . $userAvatar->avatar;

                    }else{
                        $key = $pathKey . '/' . $userAvatar->avatar;
                        $keyRsz = $pathKey . '/rsz_' . $userAvatar->avatar;
                        $keyThumb = $pathKey . '/tmb_' . $userAvatar->avatar;
                    }

                    if ($isUrl) {
                        // return image original, resized & thumb urls
                        $originalUrl = self::s3Uri($key);
                        $resizeUrl = self::s3Uri($keyRsz);
                        $thumbUrl = self::s3Uri($keyThumb);
                        $s3Client = \AWS::createClient('s3');
                        $response = $s3Client->doesObjectExist(config('filesystems.disks.s3.bucket'), $key);
                        if (!empty($response)) {
                            //$resizedUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $resizedDimensions;
                            $resizedUrl = $resizeUrl;
                            //$thumbUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $thumbDimensions;
                            $thumbUrl = $thumbUrl;
                        }else{
                            return null;
                        }
                    } else {
                        //return image s3 key
                        return $key;
                    }
                } else {
                    if ($isUrl) {

                        // dd($userAvatar->avatar);

                        if(filter_var($userAvatar->avatar, FILTER_VALIDATE_URL))
                        {
                            // return $userAvatar->$f;
                                $originalUrl = $userAvatar->avatar;
                                $resizedUrl = $userAvatar->avatar;
                                $thumbUrl = $userAvatar->avatar;
                        }
                        else
                        {
                            if (file_exists($localStoragePath . '/' . $pathKey . '/' . $userAvatar->avatar)) 
                            {
                                $originalUrl = url('/storage') . '/' . $pathKey . '/' . $userAvatar->avatar;
                                $resizedUrl = url('/storage') . '/' . $pathKey . '/' . $resizedPrefix . '_' . $userAvatar->avatar;
                                $thumbUrl = url('/storage') . '/' . $pathKey . '/' . $thumbPrefix . '_' . $userAvatar->avatar;
                            }
                        }

                        /** 
                         * Below Code Commented by jaidev
                         * 26-june-2021 
                         */

                        // if (file_exists($localStoragePath . '/' . $pathKey . '/' . $userAvatar->profile_image)) {
                        //     $originalUrl = url('/storage') . '/' . $pathKey . '/' . $userAvatar->profile_image;
                        //     $resizedUrl = url('/storage') . '/' . $pathKey . '/' . $resizedPrefix . '_' . $userAvatar->profile_image;
                        //     $thumbUrl = url('/storage') . '/' . $pathKey . '/' . $thumbPrefix . '_' . $userAvatar->profile_image;
                        // }
                    } else {
                        return $pathKey . '/' . $userAvatar->avatar;
                    }
                }
                if (!empty($originalUrl)) {
                    return [
                        'origional' => $originalUrl,
                        'resized' => $resizedUrl,
                        'thumb' => $thumbUrl,
                    ];
                }
            }
            return null;
        } else {
            //for api use: pass non numeric valuefor user_id
            return [
                'origional' => $originalUrl,
                'resized' => $resizedUrl,
                'thumb' => $thumbUrl,
            ];
        }
    }


    public static function restaurantPic($user_id = null, $isUrl = true)
    {
        if (empty($user_id)) {
            return false;
        }

        $localStoragePath = config('admin.path.STORAGE_DIR');

        $uploadDir = config('admin.path.UPLOAD_DIR');
        $avatarDir = config('admin.path.avatar.RESTAURANT_DIR');
        //concat image name with prefixes
        $resizedPrefix = config('admin.path.avatar.RESIZE_PREFIX');
        $thumbPrefix = config('admin.path.avatar.THUMB_PREFIX');

        $originalUrl = $resizedUrl = $thumbUrl = null;
        
        if (is_numeric($user_id)) {
            $userAvatar = Restaurant::select('user_id', 'restaurant_profile_photo')->where('id', $user_id)->latest()->first();
            //dd($userAvatar->restaurant_profile_photo);
            if (!empty($userAvatar->restaurant_profile_photo)) {
                $pathKey = $uploadDir . '/' . $avatarDir . '/' . $userAvatar->user_id;
                //echo $localStoragePath . '/' . $pathKey . '/' . $userAvatar->profile_image;die;
                if (env('S3_ENABLED') == true) {
                    $resizedDimensions = $thumbDimensions = '';
                    $resizedImageDimensions = request()->header('Image-Dimensions-Resized');
                    if (empty($resizedImageDimensions)) {
                        $resizedImageDimensions = config('admin.path.avatar.RESIZE_WIDTH');
                    }
                    if (!empty($resizedImageDimensions)) {
                        $keywords = explode("x", $resizedImageDimensions);
                        $resizedDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $resizedDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }
                    $thumbImageDimensions = request()->header('Image-Dimensions-Thumb');
                    if (empty($thumbImageDimensions)) {
                        $thumbImageDimensions = config('admin.path.avatar.THUMB_WIDTH');
                    }
                    if (!empty($thumbImageDimensions)) {
                        $keywords = explode("x", $thumbImageDimensions);
                        $thumbDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $thumbDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }

                    if(!empty($userAvatar->latestAvatar->avatar)){
                        $key = $pathKey . '/' . $userAvatar->latestAvatar->avatar;
                        $keyRsz = $pathKey . '/rsz_' . $userAvatar->latestAvatar->avatar;
                        $keyThumb = $pathKey . '/tmb_' . $userAvatar->latestAvatar->avatar;

                    }else{
                        $key = $pathKey . '/' . $userAvatar->profile_image;
                        $keyRsz = $pathKey . '/rsz_' . $userAvatar->profile_image;
                        $keyThumb = $pathKey . '/tmb_' . $userAvatar->profile_image;
                    }

                    if ($isUrl) {
                        // return image original, resized & thumb urls
                        $originalUrl = self::s3Uri($key);
                        $resizeUrl = self::s3Uri($keyRsz);
                        $thumbUrl = self::s3Uri($keyThumb);
                        $s3Client = \AWS::createClient('s3');
                        $response = $s3Client->doesObjectExist(config('filesystems.disks.s3.bucket'), $key);
                        if (!empty($response)) {
                            //$resizedUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $resizedDimensions;
                            $resizedUrl = $resizeUrl;
                            //$thumbUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $thumbDimensions;
                            $thumbUrl = $thumbUrl;
                        }else{
                            return null;
                        }
                    } else {
                        //return image s3 key
                        return $key;
                    }
                } else {
                    if ($isUrl) {
                        if (file_exists($localStoragePath . '/' . $pathKey . '/' . $userAvatar->restaurant_profile_photo)) {
                             $originalUrl = url('/storage') . '/' . $pathKey . '/' . $userAvatar->restaurant_profile_photo;
                            $resizedUrl = url('/storage') . '/' . $pathKey . '/' . $resizedPrefix . '_' . $userAvatar->restaurant_profile_photo;
                            $thumbUrl = url('/storage') . '/' . $pathKey . '/' . $thumbPrefix . '_' . $userAvatar->restaurant_profile_photo;
                             }
                    } else {
                        return $pathKey . '/' . $userAvatar->restaurant_profile_photo;
                    }
                }
                if (!empty($originalUrl)) {
                    
                    return [
                        'origional' => $originalUrl,
                        'resized' => $resizedUrl,
                        'thumb' => $thumbUrl,
                    ];
                }
            }
            return null;
        } else {
            //for api use: pass non numeric valuefor user_id
            return [
                'origional' => $originalUrl,
                'resized' => $resizedUrl,
                'thumb' => $thumbUrl,
            ];
        }
    }


    public static function deliverypIdproof($user_id = null,$f = null, $isUrl = true)
    {
        
        if (empty($user_id)) {
            return false;
        }

        $localStoragePath = config('admin.path.STORAGE_DIR');

        $uploadDir = config('admin.path.UPLOAD_DIR');
        $avatarDir = config('admin.path.avatar.DELIVERYP_DOC_DIR');
        //concat image name with prefixes
        $resizedPrefix = config('admin.path.avatar.RESIZE_PREFIX');
        $thumbPrefix = config('admin.path.avatar.THUMB_PREFIX');

        $originalUrl = $resizedUrl = $thumbUrl = null;
        
        if (is_numeric($user_id)) {
            $userAvatar = DeliveryPersons::select('id', $f)->where('id', $user_id)->latest()->first();
            //dd($userAvatar->restaurant_profile_photo);
            if (!empty($userAvatar->$f)) {
                $pathKey = $uploadDir . '/' . $avatarDir . '/' . $userAvatar->id;
                //echo $localStoragePath . '/' . $pathKey . '/' . $userAvatar->profile_image;die;
                if (env('S3_ENABLED') == true) {
                    $resizedDimensions = $thumbDimensions = '';
                    $resizedImageDimensions = request()->header('Image-Dimensions-Resized');
                    if (empty($resizedImageDimensions)) {
                        $resizedImageDimensions = config('admin.path.avatar.RESIZE_WIDTH');
                    }
                    if (!empty($resizedImageDimensions)) {
                        $keywords = explode("x", $resizedImageDimensions);
                        $resizedDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $resizedDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }
                    $thumbImageDimensions = request()->header('Image-Dimensions-Thumb');
                    if (empty($thumbImageDimensions)) {
                        $thumbImageDimensions = config('admin.path.avatar.THUMB_WIDTH');
                    }
                    if (!empty($thumbImageDimensions)) {
                        $keywords = explode("x", $thumbImageDimensions);
                        $thumbDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $thumbDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }

                    if(!empty($userAvatar->$f)){
                        $key = $pathKey . '/' . $userAvatar->$f;
                        $keyRsz = $pathKey . '/rsz_' . $userAvatar->$f;
                        $keyThumb = $pathKey . '/tmb_' . $userAvatar->$f;
                    }else{
                        $key = $pathKey . '/' . $userAvatar->profile_image;
                        $keyRsz = $pathKey . '/rsz_' . $userAvatar->profile_image;
                        $keyThumb = $pathKey . '/tmb_' . $userAvatar->profile_image;
                    }

                    if ($isUrl) {
                        // return image original, resized & thumb urls
                        $originalUrl = self::s3Uri($key);
                        $resizeUrl = self::s3Uri($keyRsz);
                        $thumbUrl = self::s3Uri($keyThumb);
                        $s3Client = \AWS::createClient('s3');
                        $response = $s3Client->doesObjectExist(config('filesystems.disks.s3.bucket'), $key);
                        if (!empty($response)) {
                            //$resizedUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $resizedDimensions;
                            $resizedUrl = $resizeUrl;
                            //$thumbUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $thumbDimensions;
                            $thumbUrl = $thumbUrl;
                        }else{
                            return null;
                        }
                    } else {
                        //return image s3 key
                        return $key;
                    }
                } else {
                    if ($isUrl) {
                        if(filter_var($userAvatar->$f, FILTER_VALIDATE_URL))
                        {
                            // return $userAvatar->$f;
                                $originalUrl = $userAvatar->$f;
                                $resizedUrl = $userAvatar->$f;
                                $thumbUrl = $userAvatar->$f;
                        }
                        else
                        {
                            if (file_exists($localStoragePath . '/' . $pathKey . '/' . $userAvatar->$f)) 
                            {
                                $originalUrl = url('/storage') . '/' . $pathKey . '/' . $userAvatar->$f;
                                $resizedUrl = url('/storage') . '/' . $pathKey . '/' . $resizedPrefix . '_' . $userAvatar->$f;
                                $thumbUrl = url('/storage') . '/' . $pathKey . '/' . $thumbPrefix . '_' . $userAvatar->$f;
                            }
                           
                        }
                        
                    } else {
                        return $pathKey . '/' . $userAvatar->$f;
                    }
                }
                if (!empty($originalUrl)) {
                    
                    return [
                        'origional' => $originalUrl,
                        'resized' => $resizedUrl,
                        'thumb' => $thumbUrl,
                    ];
                }
            }
            return null;
        } else {
            //for api use: pass non numeric valuefor user_id
            return [
                'origional' => $originalUrl,
                'resized' => $resizedUrl,
                'thumb' => $thumbUrl,
            ];
        }
    }


    /**
     * Author: NMG
     * function: facilityImage
     * Description: Generate facility image by faiclity id
     * Input: user id, image_id(optional), is_url(flag)
     * output: ['key'(for s3 url generation)] or ['origioanl image', 'resized image', 'thumb image']
     * Dated: 05/September/2019
     */
    public static function facilityImage($facility_id = null, $isUrl = true)
    {
        if (empty($facility_id)) {
            return false;
        }

        $localStoragePath = config('admin.path.STORAGE_DIR');

        $uploadDir = config('admin.path.UPLOAD_DIR');
        $logoDir = config('admin.path.facilityLogo.DIR');
        //concat image name with prefixes
        $resizedPrefix = config('admin.path.facilityLogo.RESIZE_PREFIX');
        $thumbPrefix = config('admin.path.facilityLogo.THUMB_PREFIX');

        $originalUrl = $resizedUrl = $thumbUrl = null;

        if (is_numeric($facility_id)) {
            $facilityLogo = Facility::select('logo')->where('id', $facility_id)->first();
            //print_r($facilityLogo);die;
            if (!empty($facilityLogo->logo)) {
                $pathKey = $uploadDir . '/' . $logoDir . '/' . $facility_id;
                //echo $localStoragePath . '/' . $pathKey . '/' . $facilityLogo->logo;die;
                if (env('S3_ENABLED') == true) {
                    $resizedDimensions = $thumbDimensions = '';
                    $resizedImageDimensions = request()->header('Image-Dimensions-Resized');
                    if (empty($resizedImageDimensions)) {
                        $resizedImageDimensions = config('admin.path.facilityLogo.RESIZE_WIDTH');
                    }
                    if (!empty($resizedImageDimensions)) {
                        $keywords = explode("x", $resizedImageDimensions);
                        $resizedDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $resizedDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }
                    $thumbImageDimensions = request()->header('Image-Dimensions-Thumb');
                    if (empty($thumbImageDimensions)) {
                        $thumbImageDimensions = config('admin.path.facilityLogo.THUMB_WIDTH');
                    }
                    if (!empty($thumbImageDimensions)) {
                        $keywords = explode("x", $thumbImageDimensions);
                        $thumbDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $thumbDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }
                    $key = $pathKey . '/' . $facilityLogo->logo;
                    if ($isUrl) {
                        // return image original, resized & thumb urls
                        $originalUrl = self::s3Uri($key);
                        $s3Client = \AWS::createClient('s3');
                        $response = $s3Client->doesObjectExist(config('filesystems.disks.s3.bucket'), $key);
                        if (!empty($response)) {
                            $resizedUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $resizedDimensions;
                            $thumbUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $thumbDimensions;
                        }else{
                            return null;
                        }
                    } else {
                        //return image s3 key
                        return $key;
                    }
                } else {
                    if ($isUrl) {
                        if (file_exists($localStoragePath . '/' . $pathKey . '/' . $facilityLogo->logo)) {
                            $originalUrl = url('/public/storage') . '/' . $pathKey . '/' . $facilityLogo->logo;
                            $resizedUrl = url('/public/storage') . '/' . $pathKey . '/' . $resizedPrefix . '_' . $facilityLogo->logo;
                            $thumbUrl = url('/public/storage') . '/' . $pathKey . '/' . $thumbPrefix . '_' . $facilityLogo->logo;
                        }
                    } else {
                        return $pathKey . '/' . $facilityLogo->logo;
                    }
                }
                if (!empty($originalUrl)) {
                    return [
                        'origional' => $originalUrl,
                        'resized' => $resizedUrl,
                        'thumb' => $thumbUrl,
                    ];
                }
            }
            return null;
        } else {
            //for api use: pass non numeric valuefor facility_id
            return [
                'origional' => $originalUrl,
                'resized' => $resizedUrl,
                'thumb' => $thumbUrl,
            ];
        }
    }


    /**
     * Author: Sandeep Kumar
     * function: getGroupImage
     * Description: It will return s3 signed url for an image
     * Input: s3 object/image 'key'ie; image path inside s3 bucket
     * output: image signed url as per expiry time
     * Dated: 05/September/2019
     */
    public static function getGroupImage($space_id = null, $isUrl = true)
    {
        if (empty($space_id)) {
            return false;
        }

        $localStoragePath = config('admin.path.STORAGE_DIR');

        $uploadDir = config('admin.path.UPLOAD_DIR');
        $groupDir = config('admin.path.groupImage.DIR');
        //concat image name with prefixes
        $resizedPrefix = config('admin.path.groupImage.RESIZE_PREFIX');
        $thumbPrefix = config('admin.path.groupImage.THUMB_PREFIX');

        $originalUrl = $resizedUrl = $thumbUrl = null;

        if (is_numeric($space_id)) {
            $groupImage = GroupImage::select('image')->where('space_id', $space_id)->first();
            //print_r($groupImage);die;
            if (!empty($groupImage->image)) {
                $pathKey = $uploadDir . '/' . $groupDir . '/' . $space_id;
                //echo $localStoragePath . '/' . $pathKey . '/' . $groupImage->logo;die;
                if (env('S3_ENABLED') == true) {
                    $resizedDimensions = $thumbDimensions = '';
                    $resizedImageDimensions = request()->header('Image-Dimensions-Resized');
                    if (empty($resizedImageDimensions)) {
                        $resizedImageDimensions = config('admin.path.groupImage.RESIZE_WIDTH');
                    }
                    if (!empty($resizedImageDimensions)) {
                        $keywords = explode("x", $resizedImageDimensions);
                        $resizedDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $resizedDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }
                    $thumbImageDimensions = request()->header('Image-Dimensions-Thumb');
                    if (empty($thumbImageDimensions)) {
                        $thumbImageDimensions = config('admin.path.groupImage.THUMB_WIDTH');
                    }
                    if (!empty($thumbImageDimensions)) {
                        $keywords = explode("x", $thumbImageDimensions);
                        $thumbDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $thumbDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }
                    $key = $pathKey . '/' . $groupImage->image;
                    $rszKey = $pathKey . '/rsz_' . $groupImage->image;
                    $tmbKey = $pathKey . '/tmb_' . $groupImage->image;
                    if ($isUrl) {
                        // return image original, resized & thumb urls
                        $originalUrl = self::s3Uri($key);
                        $rszUrl = self::s3Uri($rszKey);
                        $tmbUrl = self::s3Uri($tmbKey);
                        $s3Client = \AWS::createClient('s3');
                        $response = $s3Client->doesObjectExist(config('filesystems.disks.s3.bucket'), $key);
                        if (!empty($response)) {
                            //$resizedUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $resizedDimensions;
                            $resizedUrl = $rszUrl;
                            //$thumbUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $thumbDimensions;
                            $thumbUrl = $tmbUrl;
                        }else{
                            return null;
                        }
                    } else {
                        //return image s3 key
                        return $key;
                    }
                } else {
                    if ($isUrl) {
                        if (file_exists($localStoragePath . '/' . $pathKey . '/' . $groupImage->image)) {
                            $originalUrl = url('/public/storage') . '/' . $pathKey . '/' . $groupImage->image;
                            $resizedUrl = url('/public/storage') . '/' . $pathKey . '/' . $resizedPrefix . '_' . $groupImage->image;
                            $thumbUrl = url('/public/storage') . '/' . $pathKey . '/' . $thumbPrefix . '_' . $groupImage->image;
                        }
                    } else {
                        return $pathKey . '/' . $groupImage->image;
                    }
                }
                if (!empty($originalUrl)) {
                    return [
                        'original' => $originalUrl,
                        'resized' => $resizedUrl,
                        'thumb' => $thumbUrl,
                    ];
                }
            }
            return null;
        } else {
            //for api use: pass non numeric valuefor getGroupImage
            return [
                'original' => $originalUrl,
                'resized' => $resizedUrl,
                'thumb' => $thumbUrl,
            ];
        }
    }

    /**
     * Author: NMG
     * function: getPubNubImage
     * Description: Generate pubnub image of image path by just providing user id
     * Input: user id, image_id(optional), is_url(flag)
     * output: ['key'(for s3 url generation)] or ['origioanl image', 'resized image', 'thumb image']
     * Dated: 18/March/2020
     */
    public static function getPubNubImage($user_id = null, $isUrl = true)
    {
        if (empty($user_id)) {
            return false;
        }

        $localStoragePath = config('admin.path.STORAGE_DIR');

        $uploadDir = config('admin.path.UPLOAD_DIR');
        $pubNubDir = config('admin.path.pubNubImage.DIR');
        //concat image name with prefixes
        $resizedPrefix = config('admin.path.pubNubImage.RESIZE_PREFIX');
        $thumbPrefix = config('admin.path.pubNubImage.THUMB_PREFIX');

        $originalUrl = $resizedUrl = $thumbUrl = null;

        if (is_numeric($user_id)) {
            $pubNubImage = PubnubImage::select('id', 'image')->where('user_id', $user_id)->latest()->first();
            if (!empty($pubNubImage->image)) {
                $pathKey = $uploadDir . '/' . $pubNubDir . '/' . $user_id;
                //echo $localStoragePath . '/' . $pathKey . '/' . $userAvatar->profile_image;die;
                if (env('S3_ENABLED') == true) {
                    $resizedDimensions = $thumbDimensions = '';
                    $resizedImageDimensions = request()->header('Image-Dimensions-Resized');
                    if (empty($resizedImageDimensions)) {
                        $resizedImageDimensions = config('admin.path.pubNubImage.RESIZE_WIDTH');
                    }
                    if (!empty($resizedImageDimensions)) {
                        $keywords = explode("x", $resizedImageDimensions);
                        $resizedDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $resizedDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }
                    $thumbImageDimensions = request()->header('Image-Dimensions-Thumb');
                    if (empty($thumbImageDimensions)) {
                        $thumbImageDimensions = config('admin.path.pubNubImage.THUMB_WIDTH');
                    }
                    if (!empty($thumbImageDimensions)) {
                        $keywords = explode("x", $thumbImageDimensions);
                        $thumbDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $thumbDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }

                    if(!empty($pubNubImage->image)){
                        $key = $pathKey . '/' . $pubNubImage->image;
                        $rszKey = $pathKey . '/rsz_' . $pubNubImage->image;
                        $tmbKey = $pathKey . '/tmb_' . $pubNubImage->image;
                    }else{
                        $key = $pathKey . '/' . $pubNubImage->image;
                        $rszKey = $pathKey . '/rsz_' . $pubNubImage->image;
                        $tmbKey = $pathKey . '/tmb_' . $pubNubImage->image;
                    }

                    if ($isUrl) {
                        // return image original, resized & thumb urls
                        $originalUrl = self::s3Uri($key);
                        $rszUrl = self::s3Uri($rszKey);
                        $tmbUrl = self::s3Uri($tmbKey);
                        $s3Client = \AWS::createClient('s3');
                        $response = $s3Client->doesObjectExist(config('filesystems.disks.s3.bucket'), $key);
                        if (!empty($response)) {
                            //$resizedUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $resizedDimensions;
                            $resizedUrl = $rszUrl;
                            //$thumbUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $thumbDimensions;
                            $thumbUrl = $tmbUrl;
                        }else{
                            return null;
                        }
                    } else {
                        //return image s3 key
                        return $key;
                    }
                } else {
                    if ($isUrl) {
                        if (file_exists($localStoragePath . '/' . $pathKey . '/' . $pubNubImage->image)) {
                            $originalUrl = url('/public/storage') . '/' . $pathKey . '/' . $pubNubImage->image;
                            $resizedUrl = url('/public/storage') . '/' . $pathKey . '/' . $resizedPrefix . '_' . $pubNubImage->image;
                            $thumbUrl = url('/public/storage') . '/' . $pathKey . '/' . $thumbPrefix . '_' . $pubNubImage->image;
                        }
                    } else {
                        return $pathKey . '/' . $pubNubImage->image;
                    }
                }
                if (!empty($originalUrl)) {
                    return [
                        'original' => $originalUrl,
                        'resized' => $resizedUrl,
                        'thumb' => $thumbUrl,
                    ];
                }
            }
            return null;
        } else {
            //for api use: pass non numeric valuefor user_id
            return [
                'original' => $originalUrl,
                'resized' => $resizedUrl,
                'thumb' => $thumbUrl,
            ];
        }
    }

    /**
     * Author: NMG
     * function: getPubNubImage
     * Description: Generate pubnub image of image path by just providing user id
     * Input: user id, image_id(optional), is_url(flag)
     * output: ['key'(for s3 url generation)] or ['origioanl image', 'resized image', 'thumb image']
     * Dated: 18/March/2020
     */
    public static function getPubNubAudio($user_id = null, $isUrl = true)
    {
        if (empty($user_id)) {
            return false;
        }

        $localStoragePath = config('admin.path.STORAGE_DIR');

        $uploadDir = config('admin.path.UPLOAD_DIR');
        $pubNubDir = config('admin.path.pubNubAudio.DIR');
        //concat image name with prefixes
        $resizedPrefix = config('admin.path.pubNubAudio.RESIZE_PREFIX');
        $thumbPrefix = config('admin.path.pubNubAudio.THUMB_PREFIX');

        $originalUrl = $resizedUrl = $thumbUrl = null;

        if (is_numeric($user_id)) {
            $pubNubAudio = PubnubAudio::select('id', 'audio')->where('user_id', $user_id)->latest()->first();
            if (!empty($pubNubAudio->audio)) {
                $pathKey = $uploadDir . '/' . $pubNubDir . '/' . $user_id;
                //echo $localStoragePath . '/' . $pathKey . '/' . $userAvatar->profile_image;die;
                if (env('S3_ENABLED') == true) {
                    if(!empty($pubNubAudio->audio)){
                        $key = $pathKey . '/' . $pubNubAudio->audio;
                    }else{
                        $key = $pathKey . '/' . $pubNubAudio->audio;
                    }

                    if ($isUrl) {
                        // return image original, resized & thumb urls
                        $originalUrl = self::s3Uri($key);
                        $s3Client = \AWS::createClient('s3');
                    } else {
                        //return image s3 key
                        return $key;
                    }
                } else {
                    if ($isUrl) {
                        if (file_exists($localStoragePath . '/' . $pathKey . '/' . $pubNubAudio->audio)) {
                            $originalUrl = url('/public/storage') . '/' . $pathKey . '/' . $pubNubAudio->audio;
                        }
                    } else {
                        return $pathKey . '/' . $pubNubAudio->audio;
                    }
                }
                if (!empty($originalUrl)) {
                    return [
                        'original' => $originalUrl
                    ];
                }
            }
            return null;
        } else {
            //for api use: pass non numeric valuefor user_id
            return [
                'original' => $originalUrl,
                'resized' => $resizedUrl,
                'thumb' => $thumbUrl,
            ];
        }
    }

    /**
     * Author: NMG
     * function: s3Uri
     * Description: It will return s3 signed url for an image
     * Input: s3 object/image 'key'ie; image path inside s3 bucket
     * output: image signed url as per expiry time
     * Dated: 05/September/2019
     */   

    public static function s3Uri($key = null)
    {
        try {
            if (empty($key)) {
                return false;
            }

            $s3Client = \AWS::createClient('s3');
            return $s3Client->getObjectUrl(config('filesystems.disks.s3.bucket'), $key);
            $cmd = $s3Client->getCommand('GetObject', [
                'Bucket' => config('filesystems.disks.s3.bucket'),
                'Key' => $key,
            ]);
            $request = $s3Client->createPresignedRequest($cmd, '+10 minutes');
            return (string) $request->getUri();

            /* $s3 = \Storage::disk('s3');
        $client = $s3->getDriver()->getAdapter()->getClient();
        $expiry = env('S3_IMAGE_EXPIRY_MINUTES');
        $command = $client->getCommand('GetObject', [
        'Bucket' => config('filesystems.disks.s3.bucket'),
        'Key' => "$key",
        ]);
        $request = $client->createPresignedRequest($command, $expiry);
        return (string) $request->getUri(); */

        } catch (\Exception $e) {
           $errorLog = new \app\Http\Controllers\Api\BaseController;
           $errorLog->saveErrorLog($e);
            //echo $e->getMessage();
        }

    }

    /**
     * Author: NMG
     * function: s3PutObject
     * Description: used to store a file into s3 bucket
     * Input: s3 object/image 'key'ie; image path inside s3 bucket
     * output: image signed url as per expiry time
     * Dated: 05/September/2019
     */
    public static function s3PutObject($fileKey, $file)
    {
        try {
            $file_info = new \finfo(FILEINFO_MIME_TYPE);
            $mime_type = $file_info->buffer(file_get_contents($file));

            $extArr = explode(".", $fileKey);
            $ext = end($extArr);
            $fileArr = explode('/', $fileKey);
            $fileName = end($fileArr);

            $s3Client = \AWS::createClient('s3');

            //////////////If old image exist then delete from aws server for user image or facility images////////////
            if(!empty($fileArr[1]) && $fileArr[1] == 'facility'){
                $facility_id = $fileArr[3];

                $facilityLogo = Facility::select('logo')->where('id', $facility_id)->first();

                $uploadDir = $fileArr[0];
                $logoDir = $fileArr[1].'/'.$fileArr[2];

                $pathKey = $uploadDir . '/' . $logoDir . '/' . $facility_id;
                $key = $pathKey . '/' . $facilityLogo->logo;

            }else if(!empty($fileArr[1]) && $fileArr[1] == 'group-image'){
                $space_id = $fileArr[2];

                $groupImage = GroupImage::select('image')->where('space_id', $space_id)->first();
                $uploadDir = $fileArr[0];
                $groupImageDir = $fileArr[1].'/'.$fileArr[2];

                $pathKey = $uploadDir . '/' . $groupImageDir;
                $key = $pathKey . '/' . $groupImage->image;
            }else{

                $user_id = $fileArr[2];
                $userAvatar = User::where('id', $user_id)->latest()->first();

                $uploadDir = $fileArr[0];
                $avatarDir = $fileArr[1];

                $pathKey = $uploadDir . '/' . $avatarDir . '/' . $user_id;
                $key = $pathKey . '/' . $userAvatar->profile_image;
            }

            if(!empty($key)){
                $checkObject = $s3Client->doesObjectExist(config('filesystems.disks.s3.bucket'), $key);
                if(!empty($checkObject)){
                    self::s3DeleteObject($key);
                }
            }
            //////////////End here////////////

            $req = $s3Client->putObject([
                'Key' => $fileKey,
                'Body' => file_get_contents($file),
                'ContentType' => $mime_type,
                'Bucket' => env('AWS_BUCKET'),
                'ACL' => 'public-read',
            ]);
            return $fileName;
        } catch (\Exception $e) {
            $errorLog = new \app\Http\Controllers\Api\BaseController;
            $errorLog->saveErrorLog($e);
            //echo $e->getMessage();
        }
    }

    /**
     * Author: NMG
     * function: s3DeleteObject
     * Description: used to delete a particular object in s3 bucket
     * Input: s3 object/image 'key'ie; image path inside s3 bucket
     * output: return true/false
     * Dated: 05/September/2019
     */
    public static function s3DeleteObject($fileKey)
    {
        try {
            $s3Client = \AWS::createClient('s3');
            $obj = $s3Client->deleteObject([
                'Key' => $fileKey,
                'Bucket' => env('AWS_BUCKET'),
            ]);
            return is_null($obj) ? false : true;
        } catch (\Exception $e) {
            $errorLog = new \app\Http\Controllers\Api\BaseController;
            $errorLog->saveErrorLog($e);
            //echo $e->getMessage();
        }
    }

    /**
     * Author: NMG
     * function: s3DeleteDirectory
     * Description: used to delete a all object in s3 bucket for a particular directory
     * Input: s3 object/image 'key'ie; image path inside s3 bucket
     * output: return true/false
     * Dated: 05/September/2019
     */
    public static function s3DeleteDirectory($key = null, $except = null)
    {
        try {
            $delete = true;
            if (empty($key)) {
                return false;
            }
            $s3Client = \AWS::createClient('s3');
            $prefix = config('api.constants.path.UPLOAD_DIR') . '/' . $key;
            $objects = $s3Client->getIterator('ListObjects', ([
                'Bucket' => env('AWS_BUCKET'),
                'Prefix' => $prefix,
            ]));
            foreach ($objects as $object) {
                if ($object['Key'] != $except) {
                    $obj = $s3Client->deleteObject([
                        'Bucket' => env('AWS_BUCKET'),
                        'Key' => $object['Key'],
                    ]);
                    if (is_null($obj)) {
                        $delete = false;
                    }
                }
            }
            return $delete;
        } catch (\Exception $e) {
            $errorLog = new \app\Http\Controllers\Api\BaseController;
            $errorLog->saveErrorLog($e);
            //echo $e->getMessage();
        }
    }

    /**
     * Author: NMG
     * function: userMedia
     * Description: Generate user media of media path by just providing user id
     * Input: user id, image_id(optional), is_url(flag)
     * output: ['key'(for s3 url generation)]
     * Dated: 08/June/2020
     */

    public static function userMedia($user_id = null, $is_url = true)
    {
        if (empty($user_id)) {
            return false;
        }
        $localStoragePath = config('admin.path.STORAGE_DIR');
        $uploadDir = config('admin.path.UPLOAD_DIR');
        $mediaDir = config('admin.path.media.DIR');
        $messageUrl = '';
        $messageKey = '';
        if (is_numeric($user_id)) {
            $userMedia = Messages::select('id', 'message')->where('created_by', $user_id)->latest()->first();
  // dd($userMedia);
            if (!empty($userMedia->id)) {
                $pathKey = $uploadDir . '/' . $mediaDir . '/' . $user_id;

                if (env('S3_ENABLED') == true) {
                    if (!empty($userMedia->message)){
                        $messageKey = $pathKey . '/' . $userMedia->message;
                    }
                    $videoUrl = self::s3Uri($messageKey);
                    if ($is_url) {
                        $videoUrl = self::s3Uri($messageKey);
                        $s3Client = \AWS::createClient('s3');
                        return $videoUrl;
                    } else {
                        return [
                            'message' =>  $messageKey,
                        ];
                    }
                } else {
                    if ($is_url) {
                        if (!empty($userMedia->message) && file_exists($localStoragePath . '/' . $pathKey . '/' . $userMedia->message)) {
                            $messageUrl = url('/public/storage') . '/' . $pathKey . '/' . $userMedia->message;
                        }
                    } else {
                        return  [
                            'message' => $pathKey . '/' . $userMedia->message,
                        ];
                    }
                }
                if (!empty($messageUrl)) {
                    return  [
                        'message' => ($messageUrl) ? $messageUrl: null,
                    ];
                }
            }
            return null;
        } else {
            return [
                'error' => 'User Id must be Integer'
            ];
        }
    }
}
