<?php

namespace app\Traits;

ini_set("allow_url_fopen", 1);


use app\Model\Admin\User;
use app\Model\Admin\Restaurant;
use app\Model\Api\Messages;
use app\Model\Admin\UserAvatars;
use Illuminate\Support\Facades\Http;

trait DistanceCalculatorTrait
{
    /**
     * Author: Jaidev
     * function: distanceOneToOneApi
     * Description: Calculate Distance from one origin point to one destination point using api
     * Input: originLat , originLong , destLat , destLong
     * output: []
     * Dated: 20/July/2021
     */

    public static function distanceOneToOneApi($originLat, $originLong, $destLat, $destLong)
    {
        $url = "https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&origins=" . $originLat . "," . $originLong . "&destinations=" . $destLat . "%2C" . $destLong . "&key=" . env('ADDRESS_API_KEY');
        // $resp = json_decode(file_get_contents($url), true);

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPGET, 1);
        $curlResp = curl_exec($curl);
        curl_close($curl);
        $resp = json_decode($curlResp, true);
        if ($resp['status'] == 'OK') {
            if (!empty($resp['rows'][0]['elements'][0]['distance']['text'])) {

                // $distance  = $resp['rows'][0]['elements'][0]['distance']['text'];
                $distanceInMeters  = $resp['rows'][0]['elements'][0]['distance']['value'];
                $distanceInMiles = $distanceInMeters * 0.000621;
                // return (float) $distanceInMiles;
                return number_format((float)$distanceInMiles, 2, '.', '');
            } else {
                return  null;
            }
        }
        return null;
    }

    /**
     * Author: Jaidev
     * function: distanceOneToOne
     * Description: Calculate Distance from one origin point to one destination point manually
     * Input: lat1 , lon1 , lat2 , lon2
     * output: []
     * Dated: 21/July/2021
     */
    public static function distanceOneToOne($lat1, $lon1, $lat2, $lon2)
    {
        $pi80 = M_PI / 180;
        $lat1 *= $pi80;
        $lon1 *= $pi80;
        $lat2 *= $pi80;
        $lon2 *= $pi80;
        // $r = 6372.797; // mean radius of Earth in km
        $r = 3959; // mean radius of Earth in miles
        $dlat = $lat2 - $lat1;
        $dlon = $lon2 - $lon1;
        $a = sin($dlat / 2) * sin($dlat / 2) + cos($lat1) * cos($lat2) * sin($dlon / 2) * sin($dlon / 2);
        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
        $miles = $r * $c;
        return number_format($miles, 2, '.', '');
    }
}
