<?php

namespace app\Services\Logs;
use Illuminate\Support\Facades\Auth;
class LogProcessor
{
    public function __invoke(array $record)
    {
        if (Auth::guard('admin')->check()) {
          $record['extra'] = [
              'user_id' => Auth::guard('admin')->user() ? Auth::guard('admin')->user()->id : NULL,
              'origin' => request()->headers->get('origin'),
              'ip' => request()->server('REMOTE_ADDR'),
              'user_agent' => request()->server('HTTP_USER_AGENT')
          ];
        }else{
          $record['extra'] = [
              'user_id' => Auth::user() ? Auth::user()->id : NULL,
              'origin' => request()->headers->get('origin'),
              'ip' => request()->server('REMOTE_ADDR'),
              'user_agent' => request()->server('HTTP_USER_AGENT')
          ];
        }
        return $record;
    }
}
