<?php

namespace app\Services\Logs;
use app\Events\Logs\LogMonologEvent;
use Monolog\Logger;
use app\Model\Log;
use Monolog\Handler\AbstractProcessingHandler;
class LogHandler extends AbstractProcessingHandler {

    public function __construct($level = Logger::DEBUG) {
        parent::__construct($level);
    }

    protected function write(array $record) {
       // Simple store implementation
        $log = new Log();

        $arrRec = $record['formatted'];
        $saveArr['user_id'] = $arrRec['user_id'];
        $saveArr['origin'] = $arrRec['origin'];
        $saveArr['ip'] = $arrRec['ip'];
        $saveArr['user_agent'] = $arrRec['user_agent'];
        $saveArr['level'] = $arrRec['level'];
        $saveArr['description'] = $arrRec['description'].' File '.$arrRec['exception']['file'];
        $saveArr['token'] = $arrRec['token'];
        $saveArr['type'] = $arrRec['type'];
        $saveArr['result'] = $arrRec['result'];

        $log->fill($saveArr);
        $log->save();

        // Queue implementation
        //event(new LogMonologEvent($record));
     }
    /**
     * {@inheritDoc}
     */
    protected function getDefaultFormatter() {
        return new LogFormatter();
    }
}
