<?php

namespace app\Rules\V1;

use Illuminate\Contracts\Validation\Rule;

class ChangeEmailRule implements Rule
{
    /**
     * user
     *
     * @var [object]
     */
    private $user;
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct($user)
    {
        $this->user = $user;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if($this->user->email == $value) {
            $this->message = __('api/validation/user.error.sameEmailError');
            return false;
        }

        return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return $this->message;
    }
}
