<?php

namespace app\Rules;

use app\Enums\AddressType;
use app\Model\Api\V1\User;
use app\Model\Api\V1\Address;
use Illuminate\Contracts\Validation\Rule;

class AddressTypeRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct($id = null)
    {
        $this->id = $id;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {

        if ($this->id) {
            // dd($this->id);
            $check = Address::where(['user_id' => request()->user()->id, 'address_type' => $value])->where('id', '!=', $this->id)->get();
            if ($check->count() > 0) {
                $this->message = "You have already added " . AddressType::getKey((int) $value) . ' address';
                return false;
            }
            return true;
        }
        if (in_array($value, [AddressType::Home, AddressType::Work])) {
            $user = User::with(['addresses' => function ($q) use ($value) {
                $q->where('address_type', $value);
            }])->where('id', request()->user()->id)->first();
            if ($user->addresses->count() > 0) {
                $this->message = "You have already added " . AddressType::getKey((int) $value) . ' address';
                return false;
            }
        }
        return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return $this->message;
    }
}
