<?php
namespace app\Providers;

use Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\ServiceProvider;

class MailConfigServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }

    /**
     * @Name: Sandeep
     * @Method: store()
     * @Scope: public
     * @input: null
     * @Description: smtp db setup from database global setting table
     * @Created 29/Nov/2019
     * @Updated 29/Nov/2019
     */
    public function register()
    {
        if (\Schema::hasTable('smtp_settings')) {
            $mail = DB::table('smtp_settings')->first();
            if ($mail) //checking if table is not empty
            {
                $config = array(
                    'driver' => !empty($mail->driver) ? $mail->driver : env('MAIL_DRIVER'),
                    'host' => !empty($mail->host) ? $mail->host : env('MAIL_HOST'),
                    'port' => !empty($mail->port) ? $mail->port : env('MAIL_PORT'),
                    'encryption' => !empty($mail->encryption) ? $mail->encryption : env('MAIL_ENCRYPTION'),
                    'username' => !empty($mail->username) ? $mail->username : env('MAIL_USERNAME'),
                    'password' => !empty($mail->password) ? $mail->password : env('MAIL_PASSWORD'),
                    'sendmail' => '/usr/sbin/sendmail -bs',
                    'pretend' => false,
                );
                Config::set('mail', $config);
            }
        } else {

            $config = array(
                'driver' => env('MAIL_DRIVER'),
                'host' => env('MAIL_HOST'),
                'port' => env('MAIL_PORT'),
                'encryption' => env('MAIL_ENCRYPTION'),
                'username' => env('MAIL_USERNAME'),
                'password' => env('MAIL_PASSWORD'),
                'sendmail' => '/usr/sbin/sendmail -bs',
                'pretend' => false,
            );

            Config::set('mail', $config);

        }
    }
}