<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Laravel\Passport\Passport;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        // 'App\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        Passport::routes();
        //Passport::tokensExpireIn(now()->addMinutes(config('api.constants.EXPIR.MINUTES.TOKEN')));
        Passport::tokensExpireIn(now()->addMonths(config('api.constants.EXPIR.MONTH.ACCESS')));
        Passport::refreshTokensExpireIn(now()->addDays(config('api.constants.EXPIR.DAYS.REFRESH')));
        Passport::personalAccessTokensExpireIn(now()->addMonths(config('api.constants.EXPIR.MONTH.ACCESS')));
    }
}
