<?php
 
namespace app\Model\Vendor;

use Illuminate\Database\Eloquent\Model;
class Restaurant_menu extends Model
{
    protected $tables = 'restaurant_menus';
    protected $hidden = ['created_at', 'updated_at'];
    protected $fillable = ['restaurant_id', 'food_category_id','name', 'image', 'price','prep_time', 'allergy_advice' , 'description','status'];
    protected $guarded = []; 

    function foodCategory(){
        return $this->belongsTo('app\Model\Admin\FoodCategory' , 'food_category_id' , 'id');
    }
   static function menuItemDetails( $restaurant_id , $food_category_id , $request=false){

    
       $wh['restaurant_id'] = $restaurant_id;
       $wh['food_category_id'] = $food_category_id;
        $query = Restaurant_menu::where($wh)->with('foodCategory');

        // search 
        if(!empty($request['search_q'])){
            $search = $request['search_q'];
            $query->where(function ($q) use ($search) {
                $q->Where('restaurant_menus.name', 'LIKE', "%$search%");
            });
        }   
        
        
        return $query->orderBy('id' , 'desc')->get();
   }


   static function getDetaById($id){
        $wh['id'] = $id;
        $data = Restaurant_menu::where($wh)->with('foodCategory')->first();
        return $data;     
   }

    
}
