<?php

namespace app\Model\Vendor;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Restaurant extends Authenticatable{
    
    use Notifiable;
    
    protected $table = 'users';
    protected $guard = 'restaurant';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function setPasswordAttribute($password) {
        if (!empty($password)) {
            $this->attributes['password'] = bcrypt($password);
        }
    }

    
    public function user()
    {
        return $this->belongsTo('app\Model\Admin\User', 'id', 'owner_id');
    }

    static function restaurantShow($id)
    {
        $query = Restaurant::with('user');
          $query->orwhereHas('user', function ($q) use ($id) {
            return $q->where('id',$id);
            });
       return $query->first();

    }
}

