<?php

namespace app\Model\Vendor;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{

    protected $tables   = 'notifications';
    protected $hidden   = [];
    protected $fillable = [];
    protected $guarded  = [];


    public static function unreadCount($user_id = null)
    {
        if (empty($user_id)) {
            return false;
        }

        $total = 0;
        $total = self::where([
            ['user_id', '=', $user_id],
            ['is_read', '=', 0],
        ])->get()
            ->count();

        return $total;
    }

    public function list($request)
    {
        $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
        $query = $this->query();
        $query->when(isset($request->userId), function ($q) use ($request) {
            return $q->where('user_id', $request->userId);
        });
        $query->orderBy('id', 'desc');
        return $query->paginate($limit);
    }
}
