<?php

namespace app\Model\Vendor;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class FoodCategory extends Model
{
    protected $tables = 'food_categories';
    protected $fillable = ['name', 'status'];



    public function menuItems()
    {
        return $this->belongsTo('app\Model\Admin\Restaurant_menu', 'id', 'food_category_id');
    }



    static function list($request, $restaurantId = false)
    {
        $search = !empty($request->search) ? $request->search : '';
        $query = FoodCategory::with('menuItems');
        if ($restaurantId) {
            $query->where(function ($q) use ($restaurantId) {
                $q->orwhereHas('menuItems', function ($q) use ($restaurantId) {
                    return $q->where('restaurant_id', '=', $restaurantId);
                });
            });
        }
        if (!empty($search)) {
            $query->where(function ($q) use ($search) {
                $q->orWhere('name', 'LIKE', "%$search%");
            });
        }
        $data = $query->orderBy('id', 'DESC');
        return $data->get();
    }


    public static function getDistinctCategory($request, $restaurantOwnerId)
    {
        if ($request->input('category')) {
            $wh['food_categories.id'] = $request->input('category');
        }
        $wh['restaurants.owner_id'] = $restaurantOwnerId;
        // dd($wh);
        $query = FoodCategory::select(['food_categories.id', 'food_categories.name', DB::raw('count(*) as totalMenuItems')])
            ->join('restaurant_menus', 'food_categories.id', '=', 'restaurant_menus.food_category_id')
            ->join('restaurants', 'restaurants.id', '=', 'restaurant_menus.restaurant_id')
            ->where($wh)
            ->orderBy('food_categories.name', 'asc')
            ->groupBy('restaurant_menus.food_category_id');

        if ($request->input('search_q')) {
            $wh['food_categories.id'] = $request->input('category');
        }

        // search 
        if (!empty($request->input('search_q'))) {
            $search = $request['search_q'];
            $query->where(function ($q) use ($search) {
                $q->Where('restaurant_menus.name', 'LIKE', "%$search%");
            });
        }


        return $query->get();
    }
}
