<?php

namespace app\Model\Vendor;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class DeliveryPerson extends Model
{
    protected $table = 'delivery_persons';
    protected $hidden = ['created_at', 'updated_at'];
    protected $guarded = [];


    function user()
    {
        return $this->belongsTo('app\Model\Admin\User', 'user_id', 'id');
    }
    /** 
     * Author : Jaidev
     * Email : jaidev@nmgtechnologies.com
     * Method : find closest delivery person from the given latitude & longitude and orderid and avoid prev assigned riders
     * Create : 11/Aug/2021
     */
    public static function getClosestAvailableRider($latitude, $longitude, $orderId)
    {
        $query = DeliveryPerson::select(['id', 'latitude', 'longitude', 'user_id', DB::raw('((3959 * acos( cos( radians(' . $latitude . ') ) * cos( radians( latitude ) ) * cos( radians( longitude ) - radians(' . $longitude . ') ) + sin( radians(' . $latitude . ') ) * sin( radians( latitude ) ) ) )  ) as distance')])->orderBy('distance', 'asc')
            ->where(['work_status' => 0, 'is_approved' => 1, 'status' => 1])
            ->whereNotNull('latitude')
            ->whereNotNull('longitude')
            ->whereNotIn('id', function ($query) use ($orderId) {
                $query->select('delivery_person_id')->where(['order_id' => $orderId])->from('delivery_person_assignments');
            })
            ->with('user');

        $query->where(function ($q) {
            $q->whereHas('user', function ($q) {
                return $q->where('users.is_active', 1);
            });
        });

        return $query->first();
    }
}
