<?php

namespace app\Model\Api\v1;

use Illuminate\Database\Eloquent\Model;

class UserLog extends Model
{
    const CREATED_AT = null;
    const UPDATED_AT = null;

    protected $tables = 'user_logs';
    protected $hidden = [];
    protected $fillable = ['user_id', 'sign_in_at', 'sign_in_ip', 'plateform'];

    protected $guarded = [];

    public static function userLog($user_id = NULL){
        $clientIP = \Request::getClientIp(true);
        $user = UserLog::create([
            'user_id' => $user_id,
            'sign_in_at' => date("Y-m-d H:i:s"),
            'sign_in_ip' => $clientIP,
            'plateform' => \Request::server('HTTP_USER_AGENT'),
        ]);
    }
}
