<?php

namespace app\Model\Api\V1;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class RiderEarning extends Model
{
    protected $table = 'rider_earning';
    /**
     * attributes which are against the mass assignment.
     *
     * @var array
     */
    protected $guarded = [];

    public static function getAggregate($startDate, $endDate, $riderId)
    {
        return RiderEarning::select(DB::raw('sum(amount) as totalAmount'), DB::raw('count(order_id) as totalOrders'))->whereBetween('created_at', [$startDate, $endDate])->where('rider_id', $riderId)->first();
    }
}
