<?php

namespace app\Model\Api\V1;

use app\Model\Api\V1\User;
use app\Model\Api\V1\FoodCategory;

use Illuminate\Database\Eloquent\Model;

class RestaurantMenu extends Model
{
    /**
     * attributes of model which can not be mass-assigned.
     *
     * @var array
     */
    protected $guarded = [];
    public static function rules($id = null)
    {
        // type => [1=>Local,2=>Continental,3=>Groceries]
        return [
            'latitude' => 'bail|required|string',
            'longitude' => 'bail|string|required',
            'restaurantId' => 'bail|string|required|exists:restaurants,id',
        ];
    }

    public static function messages()
    {
        return [
            'latitude.required' => __('api/validation/restaurant.latitude.required'),
            'latitude.string' => __('api/validation/restaurant.latitude.string'),

            'longitude.required' => __('api/validation/restaurant.longitude.required'),
            'longitude.string' => __('api/validation/restaurant.longitude.string'),

            'restaurantId.required' => __('api/validation/restaurant.restaurantId.required'),
            'restaurantId.string' => __('api/validation/restaurant.restaurantId.string'),
            'restaurantId.exists' => __('api/validation/restaurant.restaurantId.exists'),

            'categoryId.required' => __('api/validation/restaurant.categoryId.required'),
            'categoryId.string' => __('api/validation/restaurant.categoryId.string'),

            'searchString.required' => __('api/validation/restaurant.searchString.required'),
            'searchString.string' => __('api/validation/restaurant.searchString.string'),

            'page.required' => __('api/validation/restaurant.page.required'),
            'page.string' => __('api/validation/restaurant.page.string'),
            'page.numeric' => __('api/validtion/restaurant.page.numeric')

        ];
    }

    function restaurant()
    {
        return $this->hasOne('app\Model\Admin\Restaurant', 'id', 'restaurant_id')->with('user');
    }

    function foodCategory()
    {
        return $this->belongsTo('app\Model\Admin\FoodCategory', 'food_category_id', 'id');
    }


    public function user()
    {
        return $this->belongsTo('app\Model\Admin\User', 'owner_id', 'id');
    }

    public static function list($request, $restaurantId, $foodCategoryId = null)
    {

        $query = self::where(['status' => 1]);
        $query->when(isset($restaurantId), function ($q) use ($restaurantId) {
            return $q->where('restaurant_id', $restaurantId);
        });
        $query->when(isset($foodCategoryId), function ($q) use ($foodCategoryId) {
            return $q->where('food_category_id', $foodCategoryId);
        });
        return $query->get();
    }
}
