<?php

namespace app\Model\Api\V1;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    const UPDATED_AT = null;

    protected $tables   = 'notifications';
    protected $hidden   = ['created_at'];
    protected $fillable = ['user_id', 'title', 'description', 'action_id', 'order_id', 'is_read', 'created_at', 'updated_at'];
    protected $guarded  = [];


    public static function rules($id = null)
    {
        return [
            'id' => 'bail|required|numeric|exists:notifications,id'
        ];
    }

    public static function messages()
    {
        return [];
    }


    public function user()
    {
        return $this->belongsTo('app\Model\Api\V1\User');
    }

    public static function unreadCount($user_id = null)
    {
        if (empty($user_id)) {
            return false;
        }

        $total = 0;
        $total = self::where([
            ['user_id', '=', $user_id],
            ['is_read', '=', 0],
        ])->get()
            ->count();

        return $total;
    }

    public function sender()
    {
        return $this->belongsTo(User::class, 'notified_by_id');
    }

    function list($request)
    {
        $limit = $request->query('limit', config('api.constants.DEFAULT_PAGE_LIMIT'));
        $query = $this->query()->orderBy('id', 'desc');
        $query->when(isset($request->userId), function ($q) use ($request) {
            return $q->where('user_id', $request->userId);
        });
        return $query->paginate($limit);
    }
}
