<?php

namespace app\Model\Api\V1;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class FoodCategory extends Model
{
    protected $tables = 'food_categories';
    protected $fillable = ['name', 'status'];



    public function menuItems()
    {
        return $this->belongsTo('app\Model\Admin\Restaurant_menu', 'id', 'food_category_id');
    }


    
    public static function list()
    {
        return FoodCategory::select(['id', 'name', 'image','isFav'])->where(['isFav' => 1])->orderBy('isFav', 'desc')->get();
    }




    public static function getDistinctCategory($restaurantId)
    {
        $wh['restaurant_menus.restaurant_id'] = $restaurantId;
        $query = FoodCategory::select(['food_categories.id', 'food_categories.name'])
            ->join('restaurant_menus', 'food_categories.id', '=', 'restaurant_menus.food_category_id')
            ->where($wh)
            ->groupBy('restaurant_menus.food_category_id');
        return $query->get();
    }
}
