<?php

namespace app\Model\Api\v1;

use Illuminate\Database\Eloquent\Model;

class EmailTemplate extends Model
{
    protected $tables = 'email_templates';
    protected $hidden = ['created_at', 'deleted_at'];
    protected $fillable = ['email_type_id', 'locale', 'subject', 'content', 'status'];
    protected $guarded = [];

    public static function fetchEmailTemplateBySlug($slug = null)
    {
        if (!empty($slug)) {
            $locale = \App::getLocale();
            $query = EmailTemplate::leftjoin('email_types', 'email_templates.email_type_id', '=', 'email_types.id')
                ->where(function ($query) use ($slug, $locale) {
                    $query->Where('email_types.slug', '=', "$slug")
                        ->Where('email_templates.locale', '=', "$locale")
                        ->Where('email_templates.status', '=', "1");
                })
                ->select('email_templates.subject', 'email_templates.content');

            $emailTemplate = $query->first();
            return $emailTemplate;
        }
        return false;
    }
}