<?php

namespace app\Model\Api\V1;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class DeliveryPerson extends Model
{
    protected $table = 'delivery_persons';
    /**
     * attributes which are against the mass assignment.
     *
     * @var array
     */
    protected $guarded = [];
    /**
     * Undocumented function
     *
     * @return void
     */


    public static function currentLocationRules()
    {
        return [
            'latitude' => 'bail|required|string',
            'longitude' => 'bail|required|string',
        ];
    }

    public static function getOrderRules()
    {
        return [
            'page' => 'bail|required|numeric',
        ];
    }



    public static function orderDetailRules()
    {
        return [
            'orderId' => 'bail|required|numeric',
        ];
    }

    public static function acceptOrderAssignmentRules()
    {
        return [
            'orderId' => 'bail|required|numeric',
        ];
    }


    public static function rejectOrderAssignmentRules()
    {
        return [
            'orderId' => 'bail|required|numeric',
            'reason' => 'bail|required|string',
        ];
    }

    public static function orderCompleteRules()
    {
        return [
            'orderId' => 'bail|required|numeric',
            'verificationCode' => 'bail|required|numeric',
        ];
    }



    public static function messages()
    {
        return [
            'latitude.required' => __('api/validation/delivery-person.latitude.required'),
            'latitude.string' => __('api/validation/delivery-person.latitude.string'),
            'latitude.required' => __('api/validation/delivery-person.latitude.required'),
            'longitude.string' => __('api/validation/delivery-person.longitude.string'),
            'page.required' => __('api/validation/delivery-person.page.required'),
            'page.numeric' => __('api/validation/delivery-person.page.numeric'),
            'orderId.required' => __('api/validation/delivery-person.orderId.required'),
            'orderId.numeric' => __('api/validation/delivery-person.orderId.numeric'),
            'verificationCode.required' => __('api/validation/delivery-person.verificationCode.required'),
            'verificationCode.numeric' => __('api/validation/delivery-person.verificationCode.numeric'),
        ];
    }


    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public static function orderList($request)
    {

        $limit = $request->query('limit', config('api.constants.DEFAULT_PAGE_LIMIT'));

        $select = ['orders.*', DB::raw('delivery_person_assignments.status as assignStatus')];
        $query = Order::select($select)->orderBy('orders.id', 'desc')->join('delivery_person_assignments', function ($join) {
            $join->on('delivery_person_assignments.delivery_person_id', '=', 'orders.delivery_person_id');
            $join->on('delivery_person_assignments.order_id', '=', 'orders.id');
        })
            ->where(['orders.delivery_person_id' => $request->delivery_person_id])->with('orderStatus')->with('orderItem')->orderBy('delivery_person_assignments.created_at', 'asc');


        $query->when(isset($request->userId), function ($q) use ($request) {
            return $q->where('user_id', $request->userId);
        });

        $query->when(isset($request->orderStatus), function ($q) use ($request) {
            return $q->where('order_status_id', $request->orderStatus);
        });

        return $query->paginate($limit);
    }

    public static function orderDetails($request)
    {
        $select = ['orders.*', DB::raw('delivery_person_assignments.status as assignStatus')];
        $query = Order::select($select)->join('delivery_person_assignments', function ($join) {
            $join->on('delivery_person_assignments.delivery_person_id', '=', 'orders.delivery_person_id');
            $join->on('delivery_person_assignments.order_id', '=', 'orders.id');
        })
            ->where(['orders.id' => $request['orderId']])->with('orderStatus')->with('orderItem')->with('restaurant');
        $query->when(isset($request->userId), function ($q) use ($request) {
            return $q->where('user_id', $request->userId);
        });
        return $query->first();
    }
}
