<?php

namespace app\Model\Api\V1;

use Illuminate\Database\Eloquent\Model;

class ContactSupport extends Model
{
    const UPDATED_AT = null;

    protected $tables = 'contact_supports';
    protected $hidden = ['created_at'];
    protected $fillable = ['user_id', 'title_id', 'title', 'message', 'restaurant_id', 'created_at'];

    public function user(){
        return $this->belongsTo('app\Model\Api\User');
    }

    public static function rules()
    {
        return [
            'title' => 'bail|required',
            'message' => 'bail|required|min:' . config('api.constants.contactSupport.message.minLength') . '|max:' . config('api.constants.contactSupport.message.maxLength')
        ];
    }

    public static function messages()
    {
        return [
            'message.required' => __('api/validation/contact-support.message.required'),
            'message.min' => __('api/validation/contact-support.message.min'),
            'message.max' => __('api/validation/contact-support.message.max'),
            'message.regex' => __('api/validation/contact-support.message.regex'),

        ];
    }
}
