<?php

namespace app\Model\Api\V1;

use app\Enums\AddressType;
use app\Model\Api\V1\User;
use app\Rules\AddressTypeRule;
use BenSampo\Enum\Rules\EnumValue;
use Illuminate\Database\Eloquent\Model;

class CartItem extends Model
{
    /**
     * attributes of model which can not be mass-assigned.
     *
     * @var array
     */
    protected $tables   = 'cart_items';
    protected $guarded = [];



    public function restaurant_menu()
    {
        return $this->hasOne('app\Model\Api\V1\RestaurantMenu', 'item_id', 'id');
    }

    public function foodItem()
    {
        return $this->hasOne('app\Model\Api\V1\RestaurantMenu', 'id', 'item_id');
    }
}
