<?php

namespace app\Model\Api\V1;

use app\Enums\AddressType;
use app\Model\Api\V1\User;
use app\Model\Api\V1\CartItem;
use app\Rules\AddressTypeRule;
use BenSampo\Enum\Rules\EnumValue;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;

class Cart extends Model
{
    /**
     * attributes of model which can not be mass-assigned.
     *
     * @var array
     */
    protected $tables   = 'cart';
    protected $guarded = [];

    public static function rules($id = null)
    {
        return [
            // 'addressId' => 'bail|required|numeric|exists:addresses,id|max:' . config('api.constants.cart.addressId.maxLength'),
            'latitude' => 'bail|required|string',
            'longitude' => 'bail|required|string',
            'itemId' => 'bail|required|numeric|exists:restaurant_menus,id|max:' . config('api.constants.cart.itemId.maxLength'),
            'itemQty' => 'bail|required|numeric|max:' . config('api.constants.cart.itemQty.maxLength'),
        ];
    }

    public static function updateAddressRules($id = null)
    {
        return [
            // 'addressId' => 'bail|required|numeric|exists:addresses,id|max:' . config('api.constants.cart.addressId.maxLength'),
            'latitude' => 'bail|required|string',
            'longitude' => 'bail|required|string',
        ];
    }

    public static function messages()
    {
        return [];
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function restaurant()
    {
        return $this->hasOne('app\Model\Api\V1\Restaurant', 'id', 'restaurant_id');
    }

    public function address()
    {
        return $this->hasOne('app\Model\Api\V1\Address', 'id', 'address_id');
    }

    public function cartItems()
    {
        return $this->hasMany('app\Model\Api\V1\CartItem', 'cart_id', 'id')->with('foodItem');
    }





    public static function summary($cartId)
    {
        $resp['totalItems'] = 0;
        $resp['totalPrice'] = 0;
        $data = Cart::select(DB::raw('count(*) as totalItems'), DB::raw('sum(cart_items.item_qty * restaurant_menus.price) as totalPrice '))
            ->leftJoin('cart_items', 'cart_items.cart_id', '=', 'carts.id')
            ->leftJoin('restaurant_menus', 'restaurant_menus.id', '=', 'cart_items.item_id')
            ->groupBy('cart_items.cart_id')
            ->where(['carts.id' => $cartId])
            ->first();

        if (!empty($data)) {
            $resp['totalItems'] = (string) $data->totalItems;
            $resp['totalPrice'] = (string) $data->totalPrice;
        }
        return $resp;
    }

    public static function list($request)
    {
        $data = Cart::where(['user_id' => $request['userId']])->with('restaurant')->with('cartItems')->with('user')->first();
        return $data;
    }

    public function checkAddressWithCoordinates($userId, $lat, $long)
    {
        $wh['user_id'] = $userId;
        $wh['latitude'] = $lat;
        $wh['longitude'] = $long;
        return Address::where($wh)->first();
    }
}
