<?php

namespace app\Model\Api\v1;

use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class BlockedUser extends Model
{
    use Sortable;

    protected $tables = 'blocked_users';
    protected $hidden = ['created_at', 'updated_at'];
    protected $fillable = ['id', 'user_id', 'blocked_by', 'blocked_reason_id'];
    public $sortable = ['id', 'user_id', 'blocked_reason_id'];

    public function blocked_reasons()
    {

        return $this->belongsTo('app\Model\Admin\BlockedReason');
    }

    public static function apiRules($id = null)
    {
        return [
            'userId' => 'bail|required',
            'reasonId' => 'bail|required',
        ];
    }

    public static function messages()
    {
        return [
            'userId.required' => __('api/validation/blocked-reason.blockUser.required'),
            'reasonId.required' => __('api/validation/blocked-reason.blockReason.required'),
        ];
    }
}